/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogEcomSeoData;
import com.squareup.square.types.CatalogItemFoodAndBeverageDetails;
import com.squareup.square.types.CatalogItemModifierListInfo;
import com.squareup.square.types.CatalogItemOptionForItem;
import com.squareup.square.types.CatalogItemProductType;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.CatalogObjectCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogItem {
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> abbreviation;
    private final Optional<String> labelColor;
    private final Optional<Boolean> isTaxable;
    private final Optional<String> categoryId;
    private final Optional<List<String>> taxIds;
    private final Optional<List<CatalogItemModifierListInfo>> modifierListInfo;
    private final Optional<List<CatalogObject>> variations;
    private final Optional<CatalogItemProductType> productType;
    private final Optional<Boolean> skipModifierScreen;
    private final Optional<List<CatalogItemOptionForItem>> itemOptions;
    private final Optional<String> ecomUri;
    private final Optional<List<String>> ecomImageUris;
    private final Optional<List<String>> imageIds;
    private final Optional<String> sortName;
    private final Optional<List<CatalogObjectCategory>> categories;
    private final Optional<String> descriptionHtml;
    private final Optional<String> descriptionPlaintext;
    private final Optional<List<String>> channels;
    private final Optional<Boolean> isArchived;
    private final Optional<CatalogEcomSeoData> ecomSeoData;
    private final Optional<CatalogItemFoodAndBeverageDetails> foodAndBeverageDetails;
    private final Optional<CatalogObjectCategory> reportingCategory;
    private final Optional<Boolean> isAlcoholic;
    private final Map<String, Object> additionalProperties;

    private CatalogItem(Optional<String> name, Optional<String> description, Optional<String> abbreviation, Optional<String> labelColor, Optional<Boolean> isTaxable, Optional<String> categoryId, Optional<List<String>> taxIds, Optional<List<CatalogItemModifierListInfo>> modifierListInfo, Optional<List<CatalogObject>> variations, Optional<CatalogItemProductType> productType, Optional<Boolean> skipModifierScreen, Optional<List<CatalogItemOptionForItem>> itemOptions, Optional<String> ecomUri, Optional<List<String>> ecomImageUris, Optional<List<String>> imageIds, Optional<String> sortName, Optional<List<CatalogObjectCategory>> categories, Optional<String> descriptionHtml, Optional<String> descriptionPlaintext, Optional<List<String>> channels, Optional<Boolean> isArchived, Optional<CatalogEcomSeoData> ecomSeoData, Optional<CatalogItemFoodAndBeverageDetails> foodAndBeverageDetails, Optional<CatalogObjectCategory> reportingCategory, Optional<Boolean> isAlcoholic, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.abbreviation = abbreviation;
        this.labelColor = labelColor;
        this.isTaxable = isTaxable;
        this.categoryId = categoryId;
        this.taxIds = taxIds;
        this.modifierListInfo = modifierListInfo;
        this.variations = variations;
        this.productType = productType;
        this.skipModifierScreen = skipModifierScreen;
        this.itemOptions = itemOptions;
        this.ecomUri = ecomUri;
        this.ecomImageUris = ecomImageUris;
        this.imageIds = imageIds;
        this.sortName = sortName;
        this.categories = categories;
        this.descriptionHtml = descriptionHtml;
        this.descriptionPlaintext = descriptionPlaintext;
        this.channels = channels;
        this.isArchived = isArchived;
        this.ecomSeoData = ecomSeoData;
        this.foodAndBeverageDetails = foodAndBeverageDetails;
        this.reportingCategory = reportingCategory;
        this.isAlcoholic = isAlcoholic;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonIgnore
    public Optional<String> getAbbreviation() {
        if (this.abbreviation == null) {
            return Optional.empty();
        }
        return this.abbreviation;
    }

    @JsonIgnore
    public Optional<String> getLabelColor() {
        if (this.labelColor == null) {
            return Optional.empty();
        }
        return this.labelColor;
    }

    @JsonIgnore
    public Optional<Boolean> getIsTaxable() {
        if (this.isTaxable == null) {
            return Optional.empty();
        }
        return this.isTaxable;
    }

    @JsonIgnore
    public Optional<String> getCategoryId() {
        if (this.categoryId == null) {
            return Optional.empty();
        }
        return this.categoryId;
    }

    @JsonIgnore
    public Optional<List<String>> getTaxIds() {
        if (this.taxIds == null) {
            return Optional.empty();
        }
        return this.taxIds;
    }

    @JsonIgnore
    public Optional<List<CatalogItemModifierListInfo>> getModifierListInfo() {
        if (this.modifierListInfo == null) {
            return Optional.empty();
        }
        return this.modifierListInfo;
    }

    @JsonIgnore
    public Optional<List<CatalogObject>> getVariations() {
        if (this.variations == null) {
            return Optional.empty();
        }
        return this.variations;
    }

    @JsonProperty(value="product_type")
    public Optional<CatalogItemProductType> getProductType() {
        return this.productType;
    }

    @JsonIgnore
    public Optional<Boolean> getSkipModifierScreen() {
        if (this.skipModifierScreen == null) {
            return Optional.empty();
        }
        return this.skipModifierScreen;
    }

    @JsonIgnore
    public Optional<List<CatalogItemOptionForItem>> getItemOptions() {
        if (this.itemOptions == null) {
            return Optional.empty();
        }
        return this.itemOptions;
    }

    @JsonIgnore
    public Optional<String> getEcomUri() {
        if (this.ecomUri == null) {
            return Optional.empty();
        }
        return this.ecomUri;
    }

    @JsonIgnore
    public Optional<List<String>> getEcomImageUris() {
        if (this.ecomImageUris == null) {
            return Optional.empty();
        }
        return this.ecomImageUris;
    }

    @JsonIgnore
    public Optional<List<String>> getImageIds() {
        if (this.imageIds == null) {
            return Optional.empty();
        }
        return this.imageIds;
    }

    @JsonIgnore
    public Optional<String> getSortName() {
        if (this.sortName == null) {
            return Optional.empty();
        }
        return this.sortName;
    }

    @JsonIgnore
    public Optional<List<CatalogObjectCategory>> getCategories() {
        if (this.categories == null) {
            return Optional.empty();
        }
        return this.categories;
    }

    @JsonIgnore
    public Optional<String> getDescriptionHtml() {
        if (this.descriptionHtml == null) {
            return Optional.empty();
        }
        return this.descriptionHtml;
    }

    @JsonProperty(value="description_plaintext")
    public Optional<String> getDescriptionPlaintext() {
        return this.descriptionPlaintext;
    }

    @JsonIgnore
    public Optional<List<String>> getChannels() {
        if (this.channels == null) {
            return Optional.empty();
        }
        return this.channels;
    }

    @JsonIgnore
    public Optional<Boolean> getIsArchived() {
        if (this.isArchived == null) {
            return Optional.empty();
        }
        return this.isArchived;
    }

    @JsonProperty(value="ecom_seo_data")
    public Optional<CatalogEcomSeoData> getEcomSeoData() {
        return this.ecomSeoData;
    }

    @JsonProperty(value="food_and_beverage_details")
    public Optional<CatalogItemFoodAndBeverageDetails> getFoodAndBeverageDetails() {
        return this.foodAndBeverageDetails;
    }

    @JsonProperty(value="reporting_category")
    public Optional<CatalogObjectCategory> getReportingCategory() {
        return this.reportingCategory;
    }

    @JsonIgnore
    public Optional<Boolean> getIsAlcoholic() {
        if (this.isAlcoholic == null) {
            return Optional.empty();
        }
        return this.isAlcoholic;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="abbreviation")
    private Optional<String> _getAbbreviation() {
        return this.abbreviation;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="label_color")
    private Optional<String> _getLabelColor() {
        return this.labelColor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_taxable")
    private Optional<Boolean> _getIsTaxable() {
        return this.isTaxable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="category_id")
    private Optional<String> _getCategoryId() {
        return this.categoryId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tax_ids")
    private Optional<List<String>> _getTaxIds() {
        return this.taxIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="modifier_list_info")
    private Optional<List<CatalogItemModifierListInfo>> _getModifierListInfo() {
        return this.modifierListInfo;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="variations")
    private Optional<List<CatalogObject>> _getVariations() {
        return this.variations;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="skip_modifier_screen")
    private Optional<Boolean> _getSkipModifierScreen() {
        return this.skipModifierScreen;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="item_options")
    private Optional<List<CatalogItemOptionForItem>> _getItemOptions() {
        return this.itemOptions;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ecom_uri")
    private Optional<String> _getEcomUri() {
        return this.ecomUri;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ecom_image_uris")
    private Optional<List<String>> _getEcomImageUris() {
        return this.ecomImageUris;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="image_ids")
    private Optional<List<String>> _getImageIds() {
        return this.imageIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_name")
    private Optional<String> _getSortName() {
        return this.sortName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="categories")
    private Optional<List<CatalogObjectCategory>> _getCategories() {
        return this.categories;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description_html")
    private Optional<String> _getDescriptionHtml() {
        return this.descriptionHtml;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="channels")
    private Optional<List<String>> _getChannels() {
        return this.channels;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_archived")
    private Optional<Boolean> _getIsArchived() {
        return this.isArchived;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_alcoholic")
    private Optional<Boolean> _getIsAlcoholic() {
        return this.isAlcoholic;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogItem && this.equalTo((CatalogItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogItem other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.abbreviation.equals(other.abbreviation) && this.labelColor.equals(other.labelColor) && this.isTaxable.equals(other.isTaxable) && this.categoryId.equals(other.categoryId) && this.taxIds.equals(other.taxIds) && this.modifierListInfo.equals(other.modifierListInfo) && this.variations.equals(other.variations) && this.productType.equals(other.productType) && this.skipModifierScreen.equals(other.skipModifierScreen) && this.itemOptions.equals(other.itemOptions) && this.ecomUri.equals(other.ecomUri) && this.ecomImageUris.equals(other.ecomImageUris) && this.imageIds.equals(other.imageIds) && this.sortName.equals(other.sortName) && this.categories.equals(other.categories) && this.descriptionHtml.equals(other.descriptionHtml) && this.descriptionPlaintext.equals(other.descriptionPlaintext) && this.channels.equals(other.channels) && this.isArchived.equals(other.isArchived) && this.ecomSeoData.equals(other.ecomSeoData) && this.foodAndBeverageDetails.equals(other.foodAndBeverageDetails) && this.reportingCategory.equals(other.reportingCategory) && this.isAlcoholic.equals(other.isAlcoholic);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.abbreviation, this.labelColor, this.isTaxable, this.categoryId, this.taxIds, this.modifierListInfo, this.variations, this.productType, this.skipModifierScreen, this.itemOptions, this.ecomUri, this.ecomImageUris, this.imageIds, this.sortName, this.categories, this.descriptionHtml, this.descriptionPlaintext, this.channels, this.isArchived, this.ecomSeoData, this.foodAndBeverageDetails, this.reportingCategory, this.isAlcoholic);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> abbreviation = Optional.empty();
        private Optional<String> labelColor = Optional.empty();
        private Optional<Boolean> isTaxable = Optional.empty();
        private Optional<String> categoryId = Optional.empty();
        private Optional<List<String>> taxIds = Optional.empty();
        private Optional<List<CatalogItemModifierListInfo>> modifierListInfo = Optional.empty();
        private Optional<List<CatalogObject>> variations = Optional.empty();
        private Optional<CatalogItemProductType> productType = Optional.empty();
        private Optional<Boolean> skipModifierScreen = Optional.empty();
        private Optional<List<CatalogItemOptionForItem>> itemOptions = Optional.empty();
        private Optional<String> ecomUri = Optional.empty();
        private Optional<List<String>> ecomImageUris = Optional.empty();
        private Optional<List<String>> imageIds = Optional.empty();
        private Optional<String> sortName = Optional.empty();
        private Optional<List<CatalogObjectCategory>> categories = Optional.empty();
        private Optional<String> descriptionHtml = Optional.empty();
        private Optional<String> descriptionPlaintext = Optional.empty();
        private Optional<List<String>> channels = Optional.empty();
        private Optional<Boolean> isArchived = Optional.empty();
        private Optional<CatalogEcomSeoData> ecomSeoData = Optional.empty();
        private Optional<CatalogItemFoodAndBeverageDetails> foodAndBeverageDetails = Optional.empty();
        private Optional<CatalogObjectCategory> reportingCategory = Optional.empty();
        private Optional<Boolean> isAlcoholic = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogItem other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.abbreviation(other.getAbbreviation());
            this.labelColor(other.getLabelColor());
            this.isTaxable(other.getIsTaxable());
            this.categoryId(other.getCategoryId());
            this.taxIds(other.getTaxIds());
            this.modifierListInfo(other.getModifierListInfo());
            this.variations(other.getVariations());
            this.productType(other.getProductType());
            this.skipModifierScreen(other.getSkipModifierScreen());
            this.itemOptions(other.getItemOptions());
            this.ecomUri(other.getEcomUri());
            this.ecomImageUris(other.getEcomImageUris());
            this.imageIds(other.getImageIds());
            this.sortName(other.getSortName());
            this.categories(other.getCategories());
            this.descriptionHtml(other.getDescriptionHtml());
            this.descriptionPlaintext(other.getDescriptionPlaintext());
            this.channels(other.getChannels());
            this.isArchived(other.getIsArchived());
            this.ecomSeoData(other.getEcomSeoData());
            this.foodAndBeverageDetails(other.getFoodAndBeverageDetails());
            this.reportingCategory(other.getReportingCategory());
            this.isAlcoholic(other.getIsAlcoholic());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="abbreviation", nulls=Nulls.SKIP)
        public Builder abbreviation(Optional<String> abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = Optional.ofNullable(abbreviation);
            return this;
        }

        public Builder abbreviation(Nullable<String> abbreviation) {
            this.abbreviation = abbreviation.isNull() ? null : (abbreviation.isEmpty() ? Optional.empty() : Optional.of(abbreviation.get()));
            return this;
        }

        @JsonSetter(value="label_color", nulls=Nulls.SKIP)
        public Builder labelColor(Optional<String> labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder labelColor(String labelColor) {
            this.labelColor = Optional.ofNullable(labelColor);
            return this;
        }

        public Builder labelColor(Nullable<String> labelColor) {
            this.labelColor = labelColor.isNull() ? null : (labelColor.isEmpty() ? Optional.empty() : Optional.of(labelColor.get()));
            return this;
        }

        @JsonSetter(value="is_taxable", nulls=Nulls.SKIP)
        public Builder isTaxable(Optional<Boolean> isTaxable) {
            this.isTaxable = isTaxable;
            return this;
        }

        public Builder isTaxable(Boolean isTaxable) {
            this.isTaxable = Optional.ofNullable(isTaxable);
            return this;
        }

        public Builder isTaxable(Nullable<Boolean> isTaxable) {
            this.isTaxable = isTaxable.isNull() ? null : (isTaxable.isEmpty() ? Optional.empty() : Optional.of(isTaxable.get()));
            return this;
        }

        @JsonSetter(value="category_id", nulls=Nulls.SKIP)
        public Builder categoryId(Optional<String> categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder categoryId(String categoryId) {
            this.categoryId = Optional.ofNullable(categoryId);
            return this;
        }

        public Builder categoryId(Nullable<String> categoryId) {
            this.categoryId = categoryId.isNull() ? null : (categoryId.isEmpty() ? Optional.empty() : Optional.of(categoryId.get()));
            return this;
        }

        @JsonSetter(value="tax_ids", nulls=Nulls.SKIP)
        public Builder taxIds(Optional<List<String>> taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Builder taxIds(List<String> taxIds) {
            this.taxIds = Optional.ofNullable(taxIds);
            return this;
        }

        public Builder taxIds(Nullable<List<String>> taxIds) {
            this.taxIds = taxIds.isNull() ? null : (taxIds.isEmpty() ? Optional.empty() : Optional.of(taxIds.get()));
            return this;
        }

        @JsonSetter(value="modifier_list_info", nulls=Nulls.SKIP)
        public Builder modifierListInfo(Optional<List<CatalogItemModifierListInfo>> modifierListInfo) {
            this.modifierListInfo = modifierListInfo;
            return this;
        }

        public Builder modifierListInfo(List<CatalogItemModifierListInfo> modifierListInfo) {
            this.modifierListInfo = Optional.ofNullable(modifierListInfo);
            return this;
        }

        public Builder modifierListInfo(Nullable<List<CatalogItemModifierListInfo>> modifierListInfo) {
            this.modifierListInfo = modifierListInfo.isNull() ? null : (modifierListInfo.isEmpty() ? Optional.empty() : Optional.of(modifierListInfo.get()));
            return this;
        }

        @JsonSetter(value="variations", nulls=Nulls.SKIP)
        public Builder variations(Optional<List<CatalogObject>> variations) {
            this.variations = variations;
            return this;
        }

        public Builder variations(List<CatalogObject> variations) {
            this.variations = Optional.ofNullable(variations);
            return this;
        }

        public Builder variations(Nullable<List<CatalogObject>> variations) {
            this.variations = variations.isNull() ? null : (variations.isEmpty() ? Optional.empty() : Optional.of(variations.get()));
            return this;
        }

        @JsonSetter(value="product_type", nulls=Nulls.SKIP)
        public Builder productType(Optional<CatalogItemProductType> productType) {
            this.productType = productType;
            return this;
        }

        public Builder productType(CatalogItemProductType productType) {
            this.productType = Optional.ofNullable(productType);
            return this;
        }

        @JsonSetter(value="skip_modifier_screen", nulls=Nulls.SKIP)
        public Builder skipModifierScreen(Optional<Boolean> skipModifierScreen) {
            this.skipModifierScreen = skipModifierScreen;
            return this;
        }

        public Builder skipModifierScreen(Boolean skipModifierScreen) {
            this.skipModifierScreen = Optional.ofNullable(skipModifierScreen);
            return this;
        }

        public Builder skipModifierScreen(Nullable<Boolean> skipModifierScreen) {
            this.skipModifierScreen = skipModifierScreen.isNull() ? null : (skipModifierScreen.isEmpty() ? Optional.empty() : Optional.of(skipModifierScreen.get()));
            return this;
        }

        @JsonSetter(value="item_options", nulls=Nulls.SKIP)
        public Builder itemOptions(Optional<List<CatalogItemOptionForItem>> itemOptions) {
            this.itemOptions = itemOptions;
            return this;
        }

        public Builder itemOptions(List<CatalogItemOptionForItem> itemOptions) {
            this.itemOptions = Optional.ofNullable(itemOptions);
            return this;
        }

        public Builder itemOptions(Nullable<List<CatalogItemOptionForItem>> itemOptions) {
            this.itemOptions = itemOptions.isNull() ? null : (itemOptions.isEmpty() ? Optional.empty() : Optional.of(itemOptions.get()));
            return this;
        }

        @JsonSetter(value="ecom_uri", nulls=Nulls.SKIP)
        public Builder ecomUri(Optional<String> ecomUri) {
            this.ecomUri = ecomUri;
            return this;
        }

        public Builder ecomUri(String ecomUri) {
            this.ecomUri = Optional.ofNullable(ecomUri);
            return this;
        }

        public Builder ecomUri(Nullable<String> ecomUri) {
            this.ecomUri = ecomUri.isNull() ? null : (ecomUri.isEmpty() ? Optional.empty() : Optional.of(ecomUri.get()));
            return this;
        }

        @JsonSetter(value="ecom_image_uris", nulls=Nulls.SKIP)
        public Builder ecomImageUris(Optional<List<String>> ecomImageUris) {
            this.ecomImageUris = ecomImageUris;
            return this;
        }

        public Builder ecomImageUris(List<String> ecomImageUris) {
            this.ecomImageUris = Optional.ofNullable(ecomImageUris);
            return this;
        }

        public Builder ecomImageUris(Nullable<List<String>> ecomImageUris) {
            this.ecomImageUris = ecomImageUris.isNull() ? null : (ecomImageUris.isEmpty() ? Optional.empty() : Optional.of(ecomImageUris.get()));
            return this;
        }

        @JsonSetter(value="image_ids", nulls=Nulls.SKIP)
        public Builder imageIds(Optional<List<String>> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = Optional.ofNullable(imageIds);
            return this;
        }

        public Builder imageIds(Nullable<List<String>> imageIds) {
            this.imageIds = imageIds.isNull() ? null : (imageIds.isEmpty() ? Optional.empty() : Optional.of(imageIds.get()));
            return this;
        }

        @JsonSetter(value="sort_name", nulls=Nulls.SKIP)
        public Builder sortName(Optional<String> sortName) {
            this.sortName = sortName;
            return this;
        }

        public Builder sortName(String sortName) {
            this.sortName = Optional.ofNullable(sortName);
            return this;
        }

        public Builder sortName(Nullable<String> sortName) {
            this.sortName = sortName.isNull() ? null : (sortName.isEmpty() ? Optional.empty() : Optional.of(sortName.get()));
            return this;
        }

        @JsonSetter(value="categories", nulls=Nulls.SKIP)
        public Builder categories(Optional<List<CatalogObjectCategory>> categories) {
            this.categories = categories;
            return this;
        }

        public Builder categories(List<CatalogObjectCategory> categories) {
            this.categories = Optional.ofNullable(categories);
            return this;
        }

        public Builder categories(Nullable<List<CatalogObjectCategory>> categories) {
            this.categories = categories.isNull() ? null : (categories.isEmpty() ? Optional.empty() : Optional.of(categories.get()));
            return this;
        }

        @JsonSetter(value="description_html", nulls=Nulls.SKIP)
        public Builder descriptionHtml(Optional<String> descriptionHtml) {
            this.descriptionHtml = descriptionHtml;
            return this;
        }

        public Builder descriptionHtml(String descriptionHtml) {
            this.descriptionHtml = Optional.ofNullable(descriptionHtml);
            return this;
        }

        public Builder descriptionHtml(Nullable<String> descriptionHtml) {
            this.descriptionHtml = descriptionHtml.isNull() ? null : (descriptionHtml.isEmpty() ? Optional.empty() : Optional.of(descriptionHtml.get()));
            return this;
        }

        @JsonSetter(value="description_plaintext", nulls=Nulls.SKIP)
        public Builder descriptionPlaintext(Optional<String> descriptionPlaintext) {
            this.descriptionPlaintext = descriptionPlaintext;
            return this;
        }

        public Builder descriptionPlaintext(String descriptionPlaintext) {
            this.descriptionPlaintext = Optional.ofNullable(descriptionPlaintext);
            return this;
        }

        @JsonSetter(value="channels", nulls=Nulls.SKIP)
        public Builder channels(Optional<List<String>> channels) {
            this.channels = channels;
            return this;
        }

        public Builder channels(List<String> channels) {
            this.channels = Optional.ofNullable(channels);
            return this;
        }

        public Builder channels(Nullable<List<String>> channels) {
            this.channels = channels.isNull() ? null : (channels.isEmpty() ? Optional.empty() : Optional.of(channels.get()));
            return this;
        }

        @JsonSetter(value="is_archived", nulls=Nulls.SKIP)
        public Builder isArchived(Optional<Boolean> isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public Builder isArchived(Boolean isArchived) {
            this.isArchived = Optional.ofNullable(isArchived);
            return this;
        }

        public Builder isArchived(Nullable<Boolean> isArchived) {
            this.isArchived = isArchived.isNull() ? null : (isArchived.isEmpty() ? Optional.empty() : Optional.of(isArchived.get()));
            return this;
        }

        @JsonSetter(value="ecom_seo_data", nulls=Nulls.SKIP)
        public Builder ecomSeoData(Optional<CatalogEcomSeoData> ecomSeoData) {
            this.ecomSeoData = ecomSeoData;
            return this;
        }

        public Builder ecomSeoData(CatalogEcomSeoData ecomSeoData) {
            this.ecomSeoData = Optional.ofNullable(ecomSeoData);
            return this;
        }

        @JsonSetter(value="food_and_beverage_details", nulls=Nulls.SKIP)
        public Builder foodAndBeverageDetails(Optional<CatalogItemFoodAndBeverageDetails> foodAndBeverageDetails) {
            this.foodAndBeverageDetails = foodAndBeverageDetails;
            return this;
        }

        public Builder foodAndBeverageDetails(CatalogItemFoodAndBeverageDetails foodAndBeverageDetails) {
            this.foodAndBeverageDetails = Optional.ofNullable(foodAndBeverageDetails);
            return this;
        }

        @JsonSetter(value="reporting_category", nulls=Nulls.SKIP)
        public Builder reportingCategory(Optional<CatalogObjectCategory> reportingCategory) {
            this.reportingCategory = reportingCategory;
            return this;
        }

        public Builder reportingCategory(CatalogObjectCategory reportingCategory) {
            this.reportingCategory = Optional.ofNullable(reportingCategory);
            return this;
        }

        @JsonSetter(value="is_alcoholic", nulls=Nulls.SKIP)
        public Builder isAlcoholic(Optional<Boolean> isAlcoholic) {
            this.isAlcoholic = isAlcoholic;
            return this;
        }

        public Builder isAlcoholic(Boolean isAlcoholic) {
            this.isAlcoholic = Optional.ofNullable(isAlcoholic);
            return this;
        }

        public Builder isAlcoholic(Nullable<Boolean> isAlcoholic) {
            this.isAlcoholic = isAlcoholic.isNull() ? null : (isAlcoholic.isEmpty() ? Optional.empty() : Optional.of(isAlcoholic.get()));
            return this;
        }

        public CatalogItem build() {
            return new CatalogItem(this.name, this.description, this.abbreviation, this.labelColor, this.isTaxable, this.categoryId, this.taxIds, this.modifierListInfo, this.variations, this.productType, this.skipModifierScreen, this.itemOptions, this.ecomUri, this.ecomImageUris, this.imageIds, this.sortName, this.categories, this.descriptionHtml, this.descriptionPlaintext, this.channels, this.isArchived, this.ecomSeoData, this.foodAndBeverageDetails, this.reportingCategory, this.isAlcoholic, this.additionalProperties);
        }
    }
}

