/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogItemFoodAndBeverageDetailsDietaryPreference;
import com.squareup.square.types.CatalogItemFoodAndBeverageDetailsIngredient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogItemFoodAndBeverageDetails {
    private final Optional<Integer> calorieCount;
    private final Optional<List<CatalogItemFoodAndBeverageDetailsDietaryPreference>> dietaryPreferences;
    private final Optional<List<CatalogItemFoodAndBeverageDetailsIngredient>> ingredients;
    private final Map<String, Object> additionalProperties;

    private CatalogItemFoodAndBeverageDetails(Optional<Integer> calorieCount, Optional<List<CatalogItemFoodAndBeverageDetailsDietaryPreference>> dietaryPreferences, Optional<List<CatalogItemFoodAndBeverageDetailsIngredient>> ingredients, Map<String, Object> additionalProperties) {
        this.calorieCount = calorieCount;
        this.dietaryPreferences = dietaryPreferences;
        this.ingredients = ingredients;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Integer> getCalorieCount() {
        if (this.calorieCount == null) {
            return Optional.empty();
        }
        return this.calorieCount;
    }

    @JsonIgnore
    public Optional<List<CatalogItemFoodAndBeverageDetailsDietaryPreference>> getDietaryPreferences() {
        if (this.dietaryPreferences == null) {
            return Optional.empty();
        }
        return this.dietaryPreferences;
    }

    @JsonIgnore
    public Optional<List<CatalogItemFoodAndBeverageDetailsIngredient>> getIngredients() {
        if (this.ingredients == null) {
            return Optional.empty();
        }
        return this.ingredients;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="calorie_count")
    private Optional<Integer> _getCalorieCount() {
        return this.calorieCount;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="dietary_preferences")
    private Optional<List<CatalogItemFoodAndBeverageDetailsDietaryPreference>> _getDietaryPreferences() {
        return this.dietaryPreferences;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ingredients")
    private Optional<List<CatalogItemFoodAndBeverageDetailsIngredient>> _getIngredients() {
        return this.ingredients;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogItemFoodAndBeverageDetails && this.equalTo((CatalogItemFoodAndBeverageDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogItemFoodAndBeverageDetails other) {
        return this.calorieCount.equals(other.calorieCount) && this.dietaryPreferences.equals(other.dietaryPreferences) && this.ingredients.equals(other.ingredients);
    }

    public int hashCode() {
        return Objects.hash(this.calorieCount, this.dietaryPreferences, this.ingredients);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> calorieCount = Optional.empty();
        private Optional<List<CatalogItemFoodAndBeverageDetailsDietaryPreference>> dietaryPreferences = Optional.empty();
        private Optional<List<CatalogItemFoodAndBeverageDetailsIngredient>> ingredients = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogItemFoodAndBeverageDetails other) {
            this.calorieCount(other.getCalorieCount());
            this.dietaryPreferences(other.getDietaryPreferences());
            this.ingredients(other.getIngredients());
            return this;
        }

        @JsonSetter(value="calorie_count", nulls=Nulls.SKIP)
        public Builder calorieCount(Optional<Integer> calorieCount) {
            this.calorieCount = calorieCount;
            return this;
        }

        public Builder calorieCount(Integer calorieCount) {
            this.calorieCount = Optional.ofNullable(calorieCount);
            return this;
        }

        public Builder calorieCount(Nullable<Integer> calorieCount) {
            this.calorieCount = calorieCount.isNull() ? null : (calorieCount.isEmpty() ? Optional.empty() : Optional.of(calorieCount.get()));
            return this;
        }

        @JsonSetter(value="dietary_preferences", nulls=Nulls.SKIP)
        public Builder dietaryPreferences(Optional<List<CatalogItemFoodAndBeverageDetailsDietaryPreference>> dietaryPreferences) {
            this.dietaryPreferences = dietaryPreferences;
            return this;
        }

        public Builder dietaryPreferences(List<CatalogItemFoodAndBeverageDetailsDietaryPreference> dietaryPreferences) {
            this.dietaryPreferences = Optional.ofNullable(dietaryPreferences);
            return this;
        }

        public Builder dietaryPreferences(Nullable<List<CatalogItemFoodAndBeverageDetailsDietaryPreference>> dietaryPreferences) {
            this.dietaryPreferences = dietaryPreferences.isNull() ? null : (dietaryPreferences.isEmpty() ? Optional.empty() : Optional.of(dietaryPreferences.get()));
            return this;
        }

        @JsonSetter(value="ingredients", nulls=Nulls.SKIP)
        public Builder ingredients(Optional<List<CatalogItemFoodAndBeverageDetailsIngredient>> ingredients) {
            this.ingredients = ingredients;
            return this;
        }

        public Builder ingredients(List<CatalogItemFoodAndBeverageDetailsIngredient> ingredients) {
            this.ingredients = Optional.ofNullable(ingredients);
            return this;
        }

        public Builder ingredients(Nullable<List<CatalogItemFoodAndBeverageDetailsIngredient>> ingredients) {
            this.ingredients = ingredients.isNull() ? null : (ingredients.isEmpty() ? Optional.empty() : Optional.of(ingredients.get()));
            return this;
        }

        public CatalogItemFoodAndBeverageDetails build() {
            return new CatalogItemFoodAndBeverageDetails(this.calorieCount, this.dietaryPreferences, this.ingredients, this.additionalProperties);
        }
    }
}

