/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogItemOption {
    private final Optional<String> name;
    private final Optional<String> displayName;
    private final Optional<String> description;
    private final Optional<Boolean> showColors;
    private final Optional<List<CatalogObject>> values;
    private final Map<String, Object> additionalProperties;

    private CatalogItemOption(Optional<String> name, Optional<String> displayName, Optional<String> description, Optional<Boolean> showColors, Optional<List<CatalogObject>> values, Map<String, Object> additionalProperties) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.showColors = showColors;
        this.values = values;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getDisplayName() {
        if (this.displayName == null) {
            return Optional.empty();
        }
        return this.displayName;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonIgnore
    public Optional<Boolean> getShowColors() {
        if (this.showColors == null) {
            return Optional.empty();
        }
        return this.showColors;
    }

    @JsonIgnore
    public Optional<List<CatalogObject>> getValues() {
        if (this.values == null) {
            return Optional.empty();
        }
        return this.values;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="display_name")
    private Optional<String> _getDisplayName() {
        return this.displayName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="show_colors")
    private Optional<Boolean> _getShowColors() {
        return this.showColors;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="values")
    private Optional<List<CatalogObject>> _getValues() {
        return this.values;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogItemOption && this.equalTo((CatalogItemOption)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogItemOption other) {
        return this.name.equals(other.name) && this.displayName.equals(other.displayName) && this.description.equals(other.description) && this.showColors.equals(other.showColors) && this.values.equals(other.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.showColors, this.values);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Boolean> showColors = Optional.empty();
        private Optional<List<CatalogObject>> values = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogItemOption other) {
            this.name(other.getName());
            this.displayName(other.getDisplayName());
            this.description(other.getDescription());
            this.showColors(other.getShowColors());
            this.values(other.getValues());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public Builder displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        public Builder displayName(Nullable<String> displayName) {
            this.displayName = displayName.isNull() ? null : (displayName.isEmpty() ? Optional.empty() : Optional.of(displayName.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="show_colors", nulls=Nulls.SKIP)
        public Builder showColors(Optional<Boolean> showColors) {
            this.showColors = showColors;
            return this;
        }

        public Builder showColors(Boolean showColors) {
            this.showColors = Optional.ofNullable(showColors);
            return this;
        }

        public Builder showColors(Nullable<Boolean> showColors) {
            this.showColors = showColors.isNull() ? null : (showColors.isEmpty() ? Optional.empty() : Optional.of(showColors.get()));
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Optional<List<CatalogObject>> values) {
            this.values = values;
            return this;
        }

        public Builder values(List<CatalogObject> values) {
            this.values = Optional.ofNullable(values);
            return this;
        }

        public Builder values(Nullable<List<CatalogObject>> values) {
            this.values = values.isNull() ? null : (values.isEmpty() ? Optional.empty() : Optional.of(values.get()));
            return this;
        }

        public CatalogItemOption build() {
            return new CatalogItemOption(this.name, this.displayName, this.description, this.showColors, this.values, this.additionalProperties);
        }
    }
}

