/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogItemOptionValueForItemVariation;
import com.squareup.square.types.CatalogPricingType;
import com.squareup.square.types.CatalogStockConversion;
import com.squareup.square.types.InventoryAlertType;
import com.squareup.square.types.ItemVariationLocationOverrides;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogItemVariation {
    private final Optional<String> itemId;
    private final Optional<String> name;
    private final Optional<String> sku;
    private final Optional<String> upc;
    private final Optional<Integer> ordinal;
    private final Optional<CatalogPricingType> pricingType;
    private final Optional<Money> priceMoney;
    private final Optional<List<ItemVariationLocationOverrides>> locationOverrides;
    private final Optional<Boolean> trackInventory;
    private final Optional<InventoryAlertType> inventoryAlertType;
    private final Optional<Long> inventoryAlertThreshold;
    private final Optional<String> userData;
    private final Optional<Long> serviceDuration;
    private final Optional<Boolean> availableForBooking;
    private final Optional<List<CatalogItemOptionValueForItemVariation>> itemOptionValues;
    private final Optional<String> measurementUnitId;
    private final Optional<Boolean> sellable;
    private final Optional<Boolean> stockable;
    private final Optional<List<String>> imageIds;
    private final Optional<List<String>> teamMemberIds;
    private final Optional<CatalogStockConversion> stockableConversion;
    private final Map<String, Object> additionalProperties;

    private CatalogItemVariation(Optional<String> itemId, Optional<String> name, Optional<String> sku, Optional<String> upc, Optional<Integer> ordinal, Optional<CatalogPricingType> pricingType, Optional<Money> priceMoney, Optional<List<ItemVariationLocationOverrides>> locationOverrides, Optional<Boolean> trackInventory, Optional<InventoryAlertType> inventoryAlertType, Optional<Long> inventoryAlertThreshold, Optional<String> userData, Optional<Long> serviceDuration, Optional<Boolean> availableForBooking, Optional<List<CatalogItemOptionValueForItemVariation>> itemOptionValues, Optional<String> measurementUnitId, Optional<Boolean> sellable, Optional<Boolean> stockable, Optional<List<String>> imageIds, Optional<List<String>> teamMemberIds, Optional<CatalogStockConversion> stockableConversion, Map<String, Object> additionalProperties) {
        this.itemId = itemId;
        this.name = name;
        this.sku = sku;
        this.upc = upc;
        this.ordinal = ordinal;
        this.pricingType = pricingType;
        this.priceMoney = priceMoney;
        this.locationOverrides = locationOverrides;
        this.trackInventory = trackInventory;
        this.inventoryAlertType = inventoryAlertType;
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        this.userData = userData;
        this.serviceDuration = serviceDuration;
        this.availableForBooking = availableForBooking;
        this.itemOptionValues = itemOptionValues;
        this.measurementUnitId = measurementUnitId;
        this.sellable = sellable;
        this.stockable = stockable;
        this.imageIds = imageIds;
        this.teamMemberIds = teamMemberIds;
        this.stockableConversion = stockableConversion;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getItemId() {
        if (this.itemId == null) {
            return Optional.empty();
        }
        return this.itemId;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getSku() {
        if (this.sku == null) {
            return Optional.empty();
        }
        return this.sku;
    }

    @JsonIgnore
    public Optional<String> getUpc() {
        if (this.upc == null) {
            return Optional.empty();
        }
        return this.upc;
    }

    @JsonProperty(value="ordinal")
    public Optional<Integer> getOrdinal() {
        return this.ordinal;
    }

    @JsonProperty(value="pricing_type")
    public Optional<CatalogPricingType> getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="price_money")
    public Optional<Money> getPriceMoney() {
        return this.priceMoney;
    }

    @JsonIgnore
    public Optional<List<ItemVariationLocationOverrides>> getLocationOverrides() {
        if (this.locationOverrides == null) {
            return Optional.empty();
        }
        return this.locationOverrides;
    }

    @JsonIgnore
    public Optional<Boolean> getTrackInventory() {
        if (this.trackInventory == null) {
            return Optional.empty();
        }
        return this.trackInventory;
    }

    @JsonProperty(value="inventory_alert_type")
    public Optional<InventoryAlertType> getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    @JsonIgnore
    public Optional<Long> getInventoryAlertThreshold() {
        if (this.inventoryAlertThreshold == null) {
            return Optional.empty();
        }
        return this.inventoryAlertThreshold;
    }

    @JsonIgnore
    public Optional<String> getUserData() {
        if (this.userData == null) {
            return Optional.empty();
        }
        return this.userData;
    }

    @JsonIgnore
    public Optional<Long> getServiceDuration() {
        if (this.serviceDuration == null) {
            return Optional.empty();
        }
        return this.serviceDuration;
    }

    @JsonIgnore
    public Optional<Boolean> getAvailableForBooking() {
        if (this.availableForBooking == null) {
            return Optional.empty();
        }
        return this.availableForBooking;
    }

    @JsonIgnore
    public Optional<List<CatalogItemOptionValueForItemVariation>> getItemOptionValues() {
        if (this.itemOptionValues == null) {
            return Optional.empty();
        }
        return this.itemOptionValues;
    }

    @JsonIgnore
    public Optional<String> getMeasurementUnitId() {
        if (this.measurementUnitId == null) {
            return Optional.empty();
        }
        return this.measurementUnitId;
    }

    @JsonIgnore
    public Optional<Boolean> getSellable() {
        if (this.sellable == null) {
            return Optional.empty();
        }
        return this.sellable;
    }

    @JsonIgnore
    public Optional<Boolean> getStockable() {
        if (this.stockable == null) {
            return Optional.empty();
        }
        return this.stockable;
    }

    @JsonIgnore
    public Optional<List<String>> getImageIds() {
        if (this.imageIds == null) {
            return Optional.empty();
        }
        return this.imageIds;
    }

    @JsonIgnore
    public Optional<List<String>> getTeamMemberIds() {
        if (this.teamMemberIds == null) {
            return Optional.empty();
        }
        return this.teamMemberIds;
    }

    @JsonProperty(value="stockable_conversion")
    public Optional<CatalogStockConversion> getStockableConversion() {
        return this.stockableConversion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="item_id")
    private Optional<String> _getItemId() {
        return this.itemId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sku")
    private Optional<String> _getSku() {
        return this.sku;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="upc")
    private Optional<String> _getUpc() {
        return this.upc;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_overrides")
    private Optional<List<ItemVariationLocationOverrides>> _getLocationOverrides() {
        return this.locationOverrides;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="track_inventory")
    private Optional<Boolean> _getTrackInventory() {
        return this.trackInventory;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="inventory_alert_threshold")
    private Optional<Long> _getInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="user_data")
    private Optional<String> _getUserData() {
        return this.userData;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="service_duration")
    private Optional<Long> _getServiceDuration() {
        return this.serviceDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="available_for_booking")
    private Optional<Boolean> _getAvailableForBooking() {
        return this.availableForBooking;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="item_option_values")
    private Optional<List<CatalogItemOptionValueForItemVariation>> _getItemOptionValues() {
        return this.itemOptionValues;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="measurement_unit_id")
    private Optional<String> _getMeasurementUnitId() {
        return this.measurementUnitId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sellable")
    private Optional<Boolean> _getSellable() {
        return this.sellable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stockable")
    private Optional<Boolean> _getStockable() {
        return this.stockable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="image_ids")
    private Optional<List<String>> _getImageIds() {
        return this.imageIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_ids")
    private Optional<List<String>> _getTeamMemberIds() {
        return this.teamMemberIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogItemVariation && this.equalTo((CatalogItemVariation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogItemVariation other) {
        return this.itemId.equals(other.itemId) && this.name.equals(other.name) && this.sku.equals(other.sku) && this.upc.equals(other.upc) && this.ordinal.equals(other.ordinal) && this.pricingType.equals(other.pricingType) && this.priceMoney.equals(other.priceMoney) && this.locationOverrides.equals(other.locationOverrides) && this.trackInventory.equals(other.trackInventory) && this.inventoryAlertType.equals(other.inventoryAlertType) && this.inventoryAlertThreshold.equals(other.inventoryAlertThreshold) && this.userData.equals(other.userData) && this.serviceDuration.equals(other.serviceDuration) && this.availableForBooking.equals(other.availableForBooking) && this.itemOptionValues.equals(other.itemOptionValues) && this.measurementUnitId.equals(other.measurementUnitId) && this.sellable.equals(other.sellable) && this.stockable.equals(other.stockable) && this.imageIds.equals(other.imageIds) && this.teamMemberIds.equals(other.teamMemberIds) && this.stockableConversion.equals(other.stockableConversion);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.name, this.sku, this.upc, this.ordinal, this.pricingType, this.priceMoney, this.locationOverrides, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.userData, this.serviceDuration, this.availableForBooking, this.itemOptionValues, this.measurementUnitId, this.sellable, this.stockable, this.imageIds, this.teamMemberIds, this.stockableConversion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> itemId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> sku = Optional.empty();
        private Optional<String> upc = Optional.empty();
        private Optional<Integer> ordinal = Optional.empty();
        private Optional<CatalogPricingType> pricingType = Optional.empty();
        private Optional<Money> priceMoney = Optional.empty();
        private Optional<List<ItemVariationLocationOverrides>> locationOverrides = Optional.empty();
        private Optional<Boolean> trackInventory = Optional.empty();
        private Optional<InventoryAlertType> inventoryAlertType = Optional.empty();
        private Optional<Long> inventoryAlertThreshold = Optional.empty();
        private Optional<String> userData = Optional.empty();
        private Optional<Long> serviceDuration = Optional.empty();
        private Optional<Boolean> availableForBooking = Optional.empty();
        private Optional<List<CatalogItemOptionValueForItemVariation>> itemOptionValues = Optional.empty();
        private Optional<String> measurementUnitId = Optional.empty();
        private Optional<Boolean> sellable = Optional.empty();
        private Optional<Boolean> stockable = Optional.empty();
        private Optional<List<String>> imageIds = Optional.empty();
        private Optional<List<String>> teamMemberIds = Optional.empty();
        private Optional<CatalogStockConversion> stockableConversion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogItemVariation other) {
            this.itemId(other.getItemId());
            this.name(other.getName());
            this.sku(other.getSku());
            this.upc(other.getUpc());
            this.ordinal(other.getOrdinal());
            this.pricingType(other.getPricingType());
            this.priceMoney(other.getPriceMoney());
            this.locationOverrides(other.getLocationOverrides());
            this.trackInventory(other.getTrackInventory());
            this.inventoryAlertType(other.getInventoryAlertType());
            this.inventoryAlertThreshold(other.getInventoryAlertThreshold());
            this.userData(other.getUserData());
            this.serviceDuration(other.getServiceDuration());
            this.availableForBooking(other.getAvailableForBooking());
            this.itemOptionValues(other.getItemOptionValues());
            this.measurementUnitId(other.getMeasurementUnitId());
            this.sellable(other.getSellable());
            this.stockable(other.getStockable());
            this.imageIds(other.getImageIds());
            this.teamMemberIds(other.getTeamMemberIds());
            this.stockableConversion(other.getStockableConversion());
            return this;
        }

        @JsonSetter(value="item_id", nulls=Nulls.SKIP)
        public Builder itemId(Optional<String> itemId) {
            this.itemId = itemId;
            return this;
        }

        public Builder itemId(String itemId) {
            this.itemId = Optional.ofNullable(itemId);
            return this;
        }

        public Builder itemId(Nullable<String> itemId) {
            this.itemId = itemId.isNull() ? null : (itemId.isEmpty() ? Optional.empty() : Optional.of(itemId.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="sku", nulls=Nulls.SKIP)
        public Builder sku(Optional<String> sku) {
            this.sku = sku;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = Optional.ofNullable(sku);
            return this;
        }

        public Builder sku(Nullable<String> sku) {
            this.sku = sku.isNull() ? null : (sku.isEmpty() ? Optional.empty() : Optional.of(sku.get()));
            return this;
        }

        @JsonSetter(value="upc", nulls=Nulls.SKIP)
        public Builder upc(Optional<String> upc) {
            this.upc = upc;
            return this;
        }

        public Builder upc(String upc) {
            this.upc = Optional.ofNullable(upc);
            return this;
        }

        public Builder upc(Nullable<String> upc) {
            this.upc = upc.isNull() ? null : (upc.isEmpty() ? Optional.empty() : Optional.of(upc.get()));
            return this;
        }

        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public Builder ordinal(Optional<Integer> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        @JsonSetter(value="pricing_type", nulls=Nulls.SKIP)
        public Builder pricingType(Optional<CatalogPricingType> pricingType) {
            this.pricingType = pricingType;
            return this;
        }

        public Builder pricingType(CatalogPricingType pricingType) {
            this.pricingType = Optional.ofNullable(pricingType);
            return this;
        }

        @JsonSetter(value="price_money", nulls=Nulls.SKIP)
        public Builder priceMoney(Optional<Money> priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = Optional.ofNullable(priceMoney);
            return this;
        }

        @JsonSetter(value="location_overrides", nulls=Nulls.SKIP)
        public Builder locationOverrides(Optional<List<ItemVariationLocationOverrides>> locationOverrides) {
            this.locationOverrides = locationOverrides;
            return this;
        }

        public Builder locationOverrides(List<ItemVariationLocationOverrides> locationOverrides) {
            this.locationOverrides = Optional.ofNullable(locationOverrides);
            return this;
        }

        public Builder locationOverrides(Nullable<List<ItemVariationLocationOverrides>> locationOverrides) {
            this.locationOverrides = locationOverrides.isNull() ? null : (locationOverrides.isEmpty() ? Optional.empty() : Optional.of(locationOverrides.get()));
            return this;
        }

        @JsonSetter(value="track_inventory", nulls=Nulls.SKIP)
        public Builder trackInventory(Optional<Boolean> trackInventory) {
            this.trackInventory = trackInventory;
            return this;
        }

        public Builder trackInventory(Boolean trackInventory) {
            this.trackInventory = Optional.ofNullable(trackInventory);
            return this;
        }

        public Builder trackInventory(Nullable<Boolean> trackInventory) {
            this.trackInventory = trackInventory.isNull() ? null : (trackInventory.isEmpty() ? Optional.empty() : Optional.of(trackInventory.get()));
            return this;
        }

        @JsonSetter(value="inventory_alert_type", nulls=Nulls.SKIP)
        public Builder inventoryAlertType(Optional<InventoryAlertType> inventoryAlertType) {
            this.inventoryAlertType = inventoryAlertType;
            return this;
        }

        public Builder inventoryAlertType(InventoryAlertType inventoryAlertType) {
            this.inventoryAlertType = Optional.ofNullable(inventoryAlertType);
            return this;
        }

        @JsonSetter(value="inventory_alert_threshold", nulls=Nulls.SKIP)
        public Builder inventoryAlertThreshold(Optional<Long> inventoryAlertThreshold) {
            this.inventoryAlertThreshold = inventoryAlertThreshold;
            return this;
        }

        public Builder inventoryAlertThreshold(Long inventoryAlertThreshold) {
            this.inventoryAlertThreshold = Optional.ofNullable(inventoryAlertThreshold);
            return this;
        }

        public Builder inventoryAlertThreshold(Nullable<Long> inventoryAlertThreshold) {
            this.inventoryAlertThreshold = inventoryAlertThreshold.isNull() ? null : (inventoryAlertThreshold.isEmpty() ? Optional.empty() : Optional.of(inventoryAlertThreshold.get()));
            return this;
        }

        @JsonSetter(value="user_data", nulls=Nulls.SKIP)
        public Builder userData(Optional<String> userData) {
            this.userData = userData;
            return this;
        }

        public Builder userData(String userData) {
            this.userData = Optional.ofNullable(userData);
            return this;
        }

        public Builder userData(Nullable<String> userData) {
            this.userData = userData.isNull() ? null : (userData.isEmpty() ? Optional.empty() : Optional.of(userData.get()));
            return this;
        }

        @JsonSetter(value="service_duration", nulls=Nulls.SKIP)
        public Builder serviceDuration(Optional<Long> serviceDuration) {
            this.serviceDuration = serviceDuration;
            return this;
        }

        public Builder serviceDuration(Long serviceDuration) {
            this.serviceDuration = Optional.ofNullable(serviceDuration);
            return this;
        }

        public Builder serviceDuration(Nullable<Long> serviceDuration) {
            this.serviceDuration = serviceDuration.isNull() ? null : (serviceDuration.isEmpty() ? Optional.empty() : Optional.of(serviceDuration.get()));
            return this;
        }

        @JsonSetter(value="available_for_booking", nulls=Nulls.SKIP)
        public Builder availableForBooking(Optional<Boolean> availableForBooking) {
            this.availableForBooking = availableForBooking;
            return this;
        }

        public Builder availableForBooking(Boolean availableForBooking) {
            this.availableForBooking = Optional.ofNullable(availableForBooking);
            return this;
        }

        public Builder availableForBooking(Nullable<Boolean> availableForBooking) {
            this.availableForBooking = availableForBooking.isNull() ? null : (availableForBooking.isEmpty() ? Optional.empty() : Optional.of(availableForBooking.get()));
            return this;
        }

        @JsonSetter(value="item_option_values", nulls=Nulls.SKIP)
        public Builder itemOptionValues(Optional<List<CatalogItemOptionValueForItemVariation>> itemOptionValues) {
            this.itemOptionValues = itemOptionValues;
            return this;
        }

        public Builder itemOptionValues(List<CatalogItemOptionValueForItemVariation> itemOptionValues) {
            this.itemOptionValues = Optional.ofNullable(itemOptionValues);
            return this;
        }

        public Builder itemOptionValues(Nullable<List<CatalogItemOptionValueForItemVariation>> itemOptionValues) {
            this.itemOptionValues = itemOptionValues.isNull() ? null : (itemOptionValues.isEmpty() ? Optional.empty() : Optional.of(itemOptionValues.get()));
            return this;
        }

        @JsonSetter(value="measurement_unit_id", nulls=Nulls.SKIP)
        public Builder measurementUnitId(Optional<String> measurementUnitId) {
            this.measurementUnitId = measurementUnitId;
            return this;
        }

        public Builder measurementUnitId(String measurementUnitId) {
            this.measurementUnitId = Optional.ofNullable(measurementUnitId);
            return this;
        }

        public Builder measurementUnitId(Nullable<String> measurementUnitId) {
            this.measurementUnitId = measurementUnitId.isNull() ? null : (measurementUnitId.isEmpty() ? Optional.empty() : Optional.of(measurementUnitId.get()));
            return this;
        }

        @JsonSetter(value="sellable", nulls=Nulls.SKIP)
        public Builder sellable(Optional<Boolean> sellable) {
            this.sellable = sellable;
            return this;
        }

        public Builder sellable(Boolean sellable) {
            this.sellable = Optional.ofNullable(sellable);
            return this;
        }

        public Builder sellable(Nullable<Boolean> sellable) {
            this.sellable = sellable.isNull() ? null : (sellable.isEmpty() ? Optional.empty() : Optional.of(sellable.get()));
            return this;
        }

        @JsonSetter(value="stockable", nulls=Nulls.SKIP)
        public Builder stockable(Optional<Boolean> stockable) {
            this.stockable = stockable;
            return this;
        }

        public Builder stockable(Boolean stockable) {
            this.stockable = Optional.ofNullable(stockable);
            return this;
        }

        public Builder stockable(Nullable<Boolean> stockable) {
            this.stockable = stockable.isNull() ? null : (stockable.isEmpty() ? Optional.empty() : Optional.of(stockable.get()));
            return this;
        }

        @JsonSetter(value="image_ids", nulls=Nulls.SKIP)
        public Builder imageIds(Optional<List<String>> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = Optional.ofNullable(imageIds);
            return this;
        }

        public Builder imageIds(Nullable<List<String>> imageIds) {
            this.imageIds = imageIds.isNull() ? null : (imageIds.isEmpty() ? Optional.empty() : Optional.of(imageIds.get()));
            return this;
        }

        @JsonSetter(value="team_member_ids", nulls=Nulls.SKIP)
        public Builder teamMemberIds(Optional<List<String>> teamMemberIds) {
            this.teamMemberIds = teamMemberIds;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = Optional.ofNullable(teamMemberIds);
            return this;
        }

        public Builder teamMemberIds(Nullable<List<String>> teamMemberIds) {
            this.teamMemberIds = teamMemberIds.isNull() ? null : (teamMemberIds.isEmpty() ? Optional.empty() : Optional.of(teamMemberIds.get()));
            return this;
        }

        @JsonSetter(value="stockable_conversion", nulls=Nulls.SKIP)
        public Builder stockableConversion(Optional<CatalogStockConversion> stockableConversion) {
            this.stockableConversion = stockableConversion;
            return this;
        }

        public Builder stockableConversion(CatalogStockConversion stockableConversion) {
            this.stockableConversion = Optional.ofNullable(stockableConversion);
            return this;
        }

        public CatalogItemVariation build() {
            return new CatalogItemVariation(this.itemId, this.name, this.sku, this.upc, this.ordinal, this.pricingType, this.priceMoney, this.locationOverrides, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.userData, this.serviceDuration, this.availableForBooking, this.itemOptionValues, this.measurementUnitId, this.sellable, this.stockable, this.imageIds, this.teamMemberIds, this.stockableConversion, this.additionalProperties);
        }
    }
}

