/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ModifierLocationOverrides;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogModifier {
    private final Optional<String> name;
    private final Optional<Money> priceMoney;
    private final Optional<Boolean> onByDefault;
    private final Optional<Integer> ordinal;
    private final Optional<String> modifierListId;
    private final Optional<List<ModifierLocationOverrides>> locationOverrides;
    private final Optional<String> imageId;
    private final Optional<Boolean> hiddenOnline;
    private final Map<String, Object> additionalProperties;

    private CatalogModifier(Optional<String> name, Optional<Money> priceMoney, Optional<Boolean> onByDefault, Optional<Integer> ordinal, Optional<String> modifierListId, Optional<List<ModifierLocationOverrides>> locationOverrides, Optional<String> imageId, Optional<Boolean> hiddenOnline, Map<String, Object> additionalProperties) {
        this.name = name;
        this.priceMoney = priceMoney;
        this.onByDefault = onByDefault;
        this.ordinal = ordinal;
        this.modifierListId = modifierListId;
        this.locationOverrides = locationOverrides;
        this.imageId = imageId;
        this.hiddenOnline = hiddenOnline;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="price_money")
    public Optional<Money> getPriceMoney() {
        return this.priceMoney;
    }

    @JsonIgnore
    public Optional<Boolean> getOnByDefault() {
        if (this.onByDefault == null) {
            return Optional.empty();
        }
        return this.onByDefault;
    }

    @JsonIgnore
    public Optional<Integer> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonIgnore
    public Optional<String> getModifierListId() {
        if (this.modifierListId == null) {
            return Optional.empty();
        }
        return this.modifierListId;
    }

    @JsonIgnore
    public Optional<List<ModifierLocationOverrides>> getLocationOverrides() {
        if (this.locationOverrides == null) {
            return Optional.empty();
        }
        return this.locationOverrides;
    }

    @JsonIgnore
    public Optional<String> getImageId() {
        if (this.imageId == null) {
            return Optional.empty();
        }
        return this.imageId;
    }

    @JsonIgnore
    public Optional<Boolean> getHiddenOnline() {
        if (this.hiddenOnline == null) {
            return Optional.empty();
        }
        return this.hiddenOnline;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="on_by_default")
    private Optional<Boolean> _getOnByDefault() {
        return this.onByDefault;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Integer> _getOrdinal() {
        return this.ordinal;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="modifier_list_id")
    private Optional<String> _getModifierListId() {
        return this.modifierListId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_overrides")
    private Optional<List<ModifierLocationOverrides>> _getLocationOverrides() {
        return this.locationOverrides;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="image_id")
    private Optional<String> _getImageId() {
        return this.imageId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="hidden_online")
    private Optional<Boolean> _getHiddenOnline() {
        return this.hiddenOnline;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogModifier && this.equalTo((CatalogModifier)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogModifier other) {
        return this.name.equals(other.name) && this.priceMoney.equals(other.priceMoney) && this.onByDefault.equals(other.onByDefault) && this.ordinal.equals(other.ordinal) && this.modifierListId.equals(other.modifierListId) && this.locationOverrides.equals(other.locationOverrides) && this.imageId.equals(other.imageId) && this.hiddenOnline.equals(other.hiddenOnline);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.priceMoney, this.onByDefault, this.ordinal, this.modifierListId, this.locationOverrides, this.imageId, this.hiddenOnline);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<Money> priceMoney = Optional.empty();
        private Optional<Boolean> onByDefault = Optional.empty();
        private Optional<Integer> ordinal = Optional.empty();
        private Optional<String> modifierListId = Optional.empty();
        private Optional<List<ModifierLocationOverrides>> locationOverrides = Optional.empty();
        private Optional<String> imageId = Optional.empty();
        private Optional<Boolean> hiddenOnline = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogModifier other) {
            this.name(other.getName());
            this.priceMoney(other.getPriceMoney());
            this.onByDefault(other.getOnByDefault());
            this.ordinal(other.getOrdinal());
            this.modifierListId(other.getModifierListId());
            this.locationOverrides(other.getLocationOverrides());
            this.imageId(other.getImageId());
            this.hiddenOnline(other.getHiddenOnline());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="price_money", nulls=Nulls.SKIP)
        public Builder priceMoney(Optional<Money> priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = Optional.ofNullable(priceMoney);
            return this;
        }

        @JsonSetter(value="on_by_default", nulls=Nulls.SKIP)
        public Builder onByDefault(Optional<Boolean> onByDefault) {
            this.onByDefault = onByDefault;
            return this;
        }

        public Builder onByDefault(Boolean onByDefault) {
            this.onByDefault = Optional.ofNullable(onByDefault);
            return this;
        }

        public Builder onByDefault(Nullable<Boolean> onByDefault) {
            this.onByDefault = onByDefault.isNull() ? null : (onByDefault.isEmpty() ? Optional.empty() : Optional.of(onByDefault.get()));
            return this;
        }

        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public Builder ordinal(Optional<Integer> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        public Builder ordinal(Nullable<Integer> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        @JsonSetter(value="modifier_list_id", nulls=Nulls.SKIP)
        public Builder modifierListId(Optional<String> modifierListId) {
            this.modifierListId = modifierListId;
            return this;
        }

        public Builder modifierListId(String modifierListId) {
            this.modifierListId = Optional.ofNullable(modifierListId);
            return this;
        }

        public Builder modifierListId(Nullable<String> modifierListId) {
            this.modifierListId = modifierListId.isNull() ? null : (modifierListId.isEmpty() ? Optional.empty() : Optional.of(modifierListId.get()));
            return this;
        }

        @JsonSetter(value="location_overrides", nulls=Nulls.SKIP)
        public Builder locationOverrides(Optional<List<ModifierLocationOverrides>> locationOverrides) {
            this.locationOverrides = locationOverrides;
            return this;
        }

        public Builder locationOverrides(List<ModifierLocationOverrides> locationOverrides) {
            this.locationOverrides = Optional.ofNullable(locationOverrides);
            return this;
        }

        public Builder locationOverrides(Nullable<List<ModifierLocationOverrides>> locationOverrides) {
            this.locationOverrides = locationOverrides.isNull() ? null : (locationOverrides.isEmpty() ? Optional.empty() : Optional.of(locationOverrides.get()));
            return this;
        }

        @JsonSetter(value="image_id", nulls=Nulls.SKIP)
        public Builder imageId(Optional<String> imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = Optional.ofNullable(imageId);
            return this;
        }

        public Builder imageId(Nullable<String> imageId) {
            this.imageId = imageId.isNull() ? null : (imageId.isEmpty() ? Optional.empty() : Optional.of(imageId.get()));
            return this;
        }

        @JsonSetter(value="hidden_online", nulls=Nulls.SKIP)
        public Builder hiddenOnline(Optional<Boolean> hiddenOnline) {
            this.hiddenOnline = hiddenOnline;
            return this;
        }

        public Builder hiddenOnline(Boolean hiddenOnline) {
            this.hiddenOnline = Optional.ofNullable(hiddenOnline);
            return this;
        }

        public Builder hiddenOnline(Nullable<Boolean> hiddenOnline) {
            this.hiddenOnline = hiddenOnline.isNull() ? null : (hiddenOnline.isEmpty() ? Optional.empty() : Optional.of(hiddenOnline.get()));
            return this;
        }

        public CatalogModifier build() {
            return new CatalogModifier(this.name, this.priceMoney, this.onByDefault, this.ordinal, this.modifierListId, this.locationOverrides, this.imageId, this.hiddenOnline, this.additionalProperties);
        }
    }
}

