/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogCustomAttributeValue;
import com.squareup.square.types.CatalogItemOption;
import com.squareup.square.types.CatalogV1Id;
import com.squareup.square.types.ICatalogObjectBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogObjectItemOption
implements ICatalogObjectBase {
    private final String id;
    private final Optional<String> updatedAt;
    private final Optional<Long> version;
    private final Optional<Boolean> isDeleted;
    private final Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues;
    private final Optional<List<CatalogV1Id>> catalogV1Ids;
    private final Optional<Boolean> presentAtAllLocations;
    private final Optional<List<String>> presentAtLocationIds;
    private final Optional<List<String>> absentAtLocationIds;
    private final Optional<String> imageId;
    private final Optional<CatalogItemOption> itemOptionData;
    private final Map<String, Object> additionalProperties;

    private CatalogObjectItemOption(String id, Optional<String> updatedAt, Optional<Long> version, Optional<Boolean> isDeleted, Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues, Optional<List<CatalogV1Id>> catalogV1Ids, Optional<Boolean> presentAtAllLocations, Optional<List<String>> presentAtLocationIds, Optional<List<String>> absentAtLocationIds, Optional<String> imageId, Optional<CatalogItemOption> itemOptionData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.updatedAt = updatedAt;
        this.version = version;
        this.isDeleted = isDeleted;
        this.customAttributeValues = customAttributeValues;
        this.catalogV1Ids = catalogV1Ids;
        this.presentAtAllLocations = presentAtAllLocations;
        this.presentAtLocationIds = presentAtLocationIds;
        this.absentAtLocationIds = absentAtLocationIds;
        this.imageId = imageId;
        this.itemOptionData = itemOptionData;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<Long> getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="is_deleted")
    public Optional<Boolean> getIsDeleted() {
        return this.isDeleted;
    }

    @Override
    @JsonProperty(value="custom_attribute_values")
    public Optional<Map<String, CatalogCustomAttributeValue>> getCustomAttributeValues() {
        return this.customAttributeValues;
    }

    @Override
    @JsonProperty(value="catalog_v1_ids")
    public Optional<List<CatalogV1Id>> getCatalogV1Ids() {
        return this.catalogV1Ids;
    }

    @Override
    @JsonProperty(value="present_at_all_locations")
    public Optional<Boolean> getPresentAtAllLocations() {
        return this.presentAtAllLocations;
    }

    @Override
    @JsonProperty(value="present_at_location_ids")
    public Optional<List<String>> getPresentAtLocationIds() {
        return this.presentAtLocationIds;
    }

    @Override
    @JsonProperty(value="absent_at_location_ids")
    public Optional<List<String>> getAbsentAtLocationIds() {
        return this.absentAtLocationIds;
    }

    @Override
    @JsonProperty(value="image_id")
    public Optional<String> getImageId() {
        return this.imageId;
    }

    @JsonProperty(value="item_option_data")
    public Optional<CatalogItemOption> getItemOptionData() {
        return this.itemOptionData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogObjectItemOption && this.equalTo((CatalogObjectItemOption)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogObjectItemOption other) {
        return this.id.equals(other.id) && this.updatedAt.equals(other.updatedAt) && this.version.equals(other.version) && this.isDeleted.equals(other.isDeleted) && this.customAttributeValues.equals(other.customAttributeValues) && this.catalogV1Ids.equals(other.catalogV1Ids) && this.presentAtAllLocations.equals(other.presentAtAllLocations) && this.presentAtLocationIds.equals(other.presentAtLocationIds) && this.absentAtLocationIds.equals(other.absentAtLocationIds) && this.imageId.equals(other.imageId) && this.itemOptionData.equals(other.itemOptionData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.updatedAt, this.version, this.isDeleted, this.customAttributeValues, this.catalogV1Ids, this.presentAtAllLocations, this.presentAtLocationIds, this.absentAtLocationIds, this.imageId, this.itemOptionData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<CatalogItemOption> itemOptionData = Optional.empty();
        private Optional<String> imageId = Optional.empty();
        private Optional<List<String>> absentAtLocationIds = Optional.empty();
        private Optional<List<String>> presentAtLocationIds = Optional.empty();
        private Optional<Boolean> presentAtAllLocations = Optional.empty();
        private Optional<List<CatalogV1Id>> catalogV1Ids = Optional.empty();
        private Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues = Optional.empty();
        private Optional<Boolean> isDeleted = Optional.empty();
        private Optional<Long> version = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogObjectItemOption other) {
            this.id(other.getId());
            this.updatedAt(other.getUpdatedAt());
            this.version(other.getVersion());
            this.isDeleted(other.getIsDeleted());
            this.customAttributeValues(other.getCustomAttributeValues());
            this.catalogV1Ids(other.getCatalogV1Ids());
            this.presentAtAllLocations(other.getPresentAtAllLocations());
            this.presentAtLocationIds(other.getPresentAtLocationIds());
            this.absentAtLocationIds(other.getAbsentAtLocationIds());
            this.imageId(other.getImageId());
            this.itemOptionData(other.getItemOptionData());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage itemOptionData(CatalogItemOption itemOptionData) {
            this.itemOptionData = Optional.ofNullable(itemOptionData);
            return this;
        }

        @Override
        @JsonSetter(value="item_option_data", nulls=Nulls.SKIP)
        public _FinalStage itemOptionData(Optional<CatalogItemOption> itemOptionData) {
            this.itemOptionData = itemOptionData;
            return this;
        }

        @Override
        public _FinalStage imageId(String imageId) {
            this.imageId = Optional.ofNullable(imageId);
            return this;
        }

        @Override
        @JsonSetter(value="image_id", nulls=Nulls.SKIP)
        public _FinalStage imageId(Optional<String> imageId) {
            this.imageId = imageId;
            return this;
        }

        @Override
        public _FinalStage absentAtLocationIds(List<String> absentAtLocationIds) {
            this.absentAtLocationIds = Optional.ofNullable(absentAtLocationIds);
            return this;
        }

        @Override
        @JsonSetter(value="absent_at_location_ids", nulls=Nulls.SKIP)
        public _FinalStage absentAtLocationIds(Optional<List<String>> absentAtLocationIds) {
            this.absentAtLocationIds = absentAtLocationIds;
            return this;
        }

        @Override
        public _FinalStage presentAtLocationIds(List<String> presentAtLocationIds) {
            this.presentAtLocationIds = Optional.ofNullable(presentAtLocationIds);
            return this;
        }

        @Override
        @JsonSetter(value="present_at_location_ids", nulls=Nulls.SKIP)
        public _FinalStage presentAtLocationIds(Optional<List<String>> presentAtLocationIds) {
            this.presentAtLocationIds = presentAtLocationIds;
            return this;
        }

        @Override
        public _FinalStage presentAtAllLocations(Boolean presentAtAllLocations) {
            this.presentAtAllLocations = Optional.ofNullable(presentAtAllLocations);
            return this;
        }

        @Override
        @JsonSetter(value="present_at_all_locations", nulls=Nulls.SKIP)
        public _FinalStage presentAtAllLocations(Optional<Boolean> presentAtAllLocations) {
            this.presentAtAllLocations = presentAtAllLocations;
            return this;
        }

        @Override
        public _FinalStage catalogV1Ids(List<CatalogV1Id> catalogV1Ids) {
            this.catalogV1Ids = Optional.ofNullable(catalogV1Ids);
            return this;
        }

        @Override
        @JsonSetter(value="catalog_v1_ids", nulls=Nulls.SKIP)
        public _FinalStage catalogV1Ids(Optional<List<CatalogV1Id>> catalogV1Ids) {
            this.catalogV1Ids = catalogV1Ids;
            return this;
        }

        @Override
        public _FinalStage customAttributeValues(Map<String, CatalogCustomAttributeValue> customAttributeValues) {
            this.customAttributeValues = Optional.ofNullable(customAttributeValues);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute_values", nulls=Nulls.SKIP)
        public _FinalStage customAttributeValues(Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues) {
            this.customAttributeValues = customAttributeValues;
            return this;
        }

        @Override
        public _FinalStage isDeleted(Boolean isDeleted) {
            this.isDeleted = Optional.ofNullable(isDeleted);
            return this;
        }

        @Override
        @JsonSetter(value="is_deleted", nulls=Nulls.SKIP)
        public _FinalStage isDeleted(Optional<Boolean> isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @Override
        public _FinalStage version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public CatalogObjectItemOption build() {
            return new CatalogObjectItemOption(this.id, this.updatedAt, this.version, this.isDeleted, this.customAttributeValues, this.catalogV1Ids, this.presentAtAllLocations, this.presentAtLocationIds, this.absentAtLocationIds, this.imageId, this.itemOptionData, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogObjectItemOption build();

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage version(Optional<Long> var1);

        public _FinalStage version(Long var1);

        public _FinalStage isDeleted(Optional<Boolean> var1);

        public _FinalStage isDeleted(Boolean var1);

        public _FinalStage customAttributeValues(Optional<Map<String, CatalogCustomAttributeValue>> var1);

        public _FinalStage customAttributeValues(Map<String, CatalogCustomAttributeValue> var1);

        public _FinalStage catalogV1Ids(Optional<List<CatalogV1Id>> var1);

        public _FinalStage catalogV1Ids(List<CatalogV1Id> var1);

        public _FinalStage presentAtAllLocations(Optional<Boolean> var1);

        public _FinalStage presentAtAllLocations(Boolean var1);

        public _FinalStage presentAtLocationIds(Optional<List<String>> var1);

        public _FinalStage presentAtLocationIds(List<String> var1);

        public _FinalStage absentAtLocationIds(Optional<List<String>> var1);

        public _FinalStage absentAtLocationIds(List<String> var1);

        public _FinalStage imageId(Optional<String> var1);

        public _FinalStage imageId(String var1);

        public _FinalStage itemOptionData(Optional<CatalogItemOption> var1);

        public _FinalStage itemOptionData(CatalogItemOption var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(CatalogObjectItemOption var1);
    }
}

