/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogObjectReference {
    private final Optional<String> objectId;
    private final Optional<Long> catalogVersion;
    private final Map<String, Object> additionalProperties;

    private CatalogObjectReference(Optional<String> objectId, Optional<Long> catalogVersion, Map<String, Object> additionalProperties) {
        this.objectId = objectId;
        this.catalogVersion = catalogVersion;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getObjectId() {
        if (this.objectId == null) {
            return Optional.empty();
        }
        return this.objectId;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="object_id")
    private Optional<String> _getObjectId() {
        return this.objectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogObjectReference && this.equalTo((CatalogObjectReference)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogObjectReference other) {
        return this.objectId.equals(other.objectId) && this.catalogVersion.equals(other.catalogVersion);
    }

    public int hashCode() {
        return Objects.hash(this.objectId, this.catalogVersion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> objectId = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogObjectReference other) {
            this.objectId(other.getObjectId());
            this.catalogVersion(other.getCatalogVersion());
            return this;
        }

        @JsonSetter(value="object_id", nulls=Nulls.SKIP)
        public Builder objectId(Optional<String> objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = Optional.ofNullable(objectId);
            return this;
        }

        public Builder objectId(Nullable<String> objectId) {
            this.objectId = objectId.isNull() ? null : (objectId.isEmpty() ? Optional.empty() : Optional.of(objectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public Builder catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        public Builder catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        public CatalogObjectReference build() {
            return new CatalogObjectReference(this.objectId, this.catalogVersion, this.additionalProperties);
        }
    }
}

