/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQueryExact {
    private final String attributeName;
    private final String attributeValue;
    private final Map<String, Object> additionalProperties;

    private CatalogQueryExact(String attributeName, String attributeValue, Map<String, Object> additionalProperties) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonProperty(value="attribute_value")
    public String getAttributeValue() {
        return this.attributeValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQueryExact && this.equalTo((CatalogQueryExact)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQueryExact other) {
        return this.attributeName.equals(other.attributeName) && this.attributeValue.equals(other.attributeValue);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributeValue);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AttributeNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AttributeNameStage,
    AttributeValueStage,
    _FinalStage {
        private String attributeName;
        private String attributeValue;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogQueryExact other) {
            this.attributeName(other.getAttributeName());
            this.attributeValue(other.getAttributeValue());
            return this;
        }

        @Override
        @JsonSetter(value="attribute_name")
        public AttributeValueStage attributeName(@NotNull String attributeName) {
            this.attributeName = Objects.requireNonNull(attributeName, "attributeName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="attribute_value")
        public _FinalStage attributeValue(@NotNull String attributeValue) {
            this.attributeValue = Objects.requireNonNull(attributeValue, "attributeValue must not be null");
            return this;
        }

        @Override
        public CatalogQueryExact build() {
            return new CatalogQueryExact(this.attributeName, this.attributeValue, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogQueryExact build();
    }

    public static interface AttributeValueStage {
        public _FinalStage attributeValue(@NotNull String var1);
    }

    public static interface AttributeNameStage {
        public AttributeValueStage attributeName(@NotNull String var1);

        public Builder from(CatalogQueryExact var1);
    }
}

