/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQueryItemsForTax {
    private final List<String> taxIds;
    private final Map<String, Object> additionalProperties;

    private CatalogQueryItemsForTax(List<String> taxIds, Map<String, Object> additionalProperties) {
        this.taxIds = taxIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="tax_ids")
    public List<String> getTaxIds() {
        return this.taxIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQueryItemsForTax && this.equalTo((CatalogQueryItemsForTax)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQueryItemsForTax other) {
        return this.taxIds.equals(other.taxIds);
    }

    public int hashCode() {
        return Objects.hash(this.taxIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> taxIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogQueryItemsForTax other) {
            this.taxIds(other.getTaxIds());
            return this;
        }

        @JsonSetter(value="tax_ids", nulls=Nulls.SKIP)
        public Builder taxIds(List<String> taxIds) {
            this.taxIds.clear();
            this.taxIds.addAll(taxIds);
            return this;
        }

        public Builder addTaxIds(String taxIds) {
            this.taxIds.add(taxIds);
            return this;
        }

        public Builder addAllTaxIds(List<String> taxIds) {
            this.taxIds.addAll(taxIds);
            return this;
        }

        public CatalogQueryItemsForTax build() {
            return new CatalogQueryItemsForTax(this.taxIds, this.additionalProperties);
        }
    }
}

