/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQueryText {
    private final List<String> keywords;
    private final Map<String, Object> additionalProperties;

    private CatalogQueryText(List<String> keywords, Map<String, Object> additionalProperties) {
        this.keywords = keywords;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return this.keywords;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQueryText && this.equalTo((CatalogQueryText)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQueryText other) {
        return this.keywords.equals(other.keywords);
    }

    public int hashCode() {
        return Objects.hash(this.keywords);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> keywords = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogQueryText other) {
            this.keywords(other.getKeywords());
            return this;
        }

        @JsonSetter(value="keywords", nulls=Nulls.SKIP)
        public Builder keywords(List<String> keywords) {
            this.keywords.clear();
            this.keywords.addAll(keywords);
            return this;
        }

        public Builder addKeywords(String keywords) {
            this.keywords.add(keywords);
            return this;
        }

        public Builder addAllKeywords(List<String> keywords) {
            this.keywords.addAll(keywords);
            return this;
        }

        public CatalogQueryText build() {
            return new CatalogQueryText(this.keywords, this.additionalProperties);
        }
    }
}

