/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogStockConversion {
    private final String stockableItemVariationId;
    private final String stockableQuantity;
    private final String nonstockableQuantity;
    private final Map<String, Object> additionalProperties;

    private CatalogStockConversion(String stockableItemVariationId, String stockableQuantity, String nonstockableQuantity, Map<String, Object> additionalProperties) {
        this.stockableItemVariationId = stockableItemVariationId;
        this.stockableQuantity = stockableQuantity;
        this.nonstockableQuantity = nonstockableQuantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="stockable_item_variation_id")
    public String getStockableItemVariationId() {
        return this.stockableItemVariationId;
    }

    @JsonProperty(value="stockable_quantity")
    public String getStockableQuantity() {
        return this.stockableQuantity;
    }

    @JsonProperty(value="nonstockable_quantity")
    public String getNonstockableQuantity() {
        return this.nonstockableQuantity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogStockConversion && this.equalTo((CatalogStockConversion)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogStockConversion other) {
        return this.stockableItemVariationId.equals(other.stockableItemVariationId) && this.stockableQuantity.equals(other.stockableQuantity) && this.nonstockableQuantity.equals(other.nonstockableQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.stockableItemVariationId, this.stockableQuantity, this.nonstockableQuantity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StockableItemVariationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StockableItemVariationIdStage,
    StockableQuantityStage,
    NonstockableQuantityStage,
    _FinalStage {
        private String stockableItemVariationId;
        private String stockableQuantity;
        private String nonstockableQuantity;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogStockConversion other) {
            this.stockableItemVariationId(other.getStockableItemVariationId());
            this.stockableQuantity(other.getStockableQuantity());
            this.nonstockableQuantity(other.getNonstockableQuantity());
            return this;
        }

        @Override
        @JsonSetter(value="stockable_item_variation_id")
        public StockableQuantityStage stockableItemVariationId(@NotNull String stockableItemVariationId) {
            this.stockableItemVariationId = Objects.requireNonNull(stockableItemVariationId, "stockableItemVariationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="stockable_quantity")
        public NonstockableQuantityStage stockableQuantity(@NotNull String stockableQuantity) {
            this.stockableQuantity = Objects.requireNonNull(stockableQuantity, "stockableQuantity must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="nonstockable_quantity")
        public _FinalStage nonstockableQuantity(@NotNull String nonstockableQuantity) {
            this.nonstockableQuantity = Objects.requireNonNull(nonstockableQuantity, "nonstockableQuantity must not be null");
            return this;
        }

        @Override
        public CatalogStockConversion build() {
            return new CatalogStockConversion(this.stockableItemVariationId, this.stockableQuantity, this.nonstockableQuantity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogStockConversion build();
    }

    public static interface NonstockableQuantityStage {
        public _FinalStage nonstockableQuantity(@NotNull String var1);
    }

    public static interface StockableQuantityStage {
        public NonstockableQuantityStage stockableQuantity(@NotNull String var1);
    }

    public static interface StockableItemVariationIdStage {
        public StockableQuantityStage stockableItemVariationId(@NotNull String var1);

        public Builder from(CatalogStockConversion var1);
    }
}

