/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SubscriptionPhase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogSubscriptionPlanVariation {
    private final String name;
    private final List<SubscriptionPhase> phases;
    private final Optional<String> subscriptionPlanId;
    private final Optional<Long> monthlyBillingAnchorDate;
    private final Optional<Boolean> canProrate;
    private final Optional<String> successorPlanVariationId;
    private final Map<String, Object> additionalProperties;

    private CatalogSubscriptionPlanVariation(String name, List<SubscriptionPhase> phases, Optional<String> subscriptionPlanId, Optional<Long> monthlyBillingAnchorDate, Optional<Boolean> canProrate, Optional<String> successorPlanVariationId, Map<String, Object> additionalProperties) {
        this.name = name;
        this.phases = phases;
        this.subscriptionPlanId = subscriptionPlanId;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.canProrate = canProrate;
        this.successorPlanVariationId = successorPlanVariationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="phases")
    public List<SubscriptionPhase> getPhases() {
        return this.phases;
    }

    @JsonIgnore
    public Optional<String> getSubscriptionPlanId() {
        if (this.subscriptionPlanId == null) {
            return Optional.empty();
        }
        return this.subscriptionPlanId;
    }

    @JsonIgnore
    public Optional<Long> getMonthlyBillingAnchorDate() {
        if (this.monthlyBillingAnchorDate == null) {
            return Optional.empty();
        }
        return this.monthlyBillingAnchorDate;
    }

    @JsonIgnore
    public Optional<Boolean> getCanProrate() {
        if (this.canProrate == null) {
            return Optional.empty();
        }
        return this.canProrate;
    }

    @JsonIgnore
    public Optional<String> getSuccessorPlanVariationId() {
        if (this.successorPlanVariationId == null) {
            return Optional.empty();
        }
        return this.successorPlanVariationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="subscription_plan_id")
    private Optional<String> _getSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="monthly_billing_anchor_date")
    private Optional<Long> _getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="can_prorate")
    private Optional<Boolean> _getCanProrate() {
        return this.canProrate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="successor_plan_variation_id")
    private Optional<String> _getSuccessorPlanVariationId() {
        return this.successorPlanVariationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogSubscriptionPlanVariation && this.equalTo((CatalogSubscriptionPlanVariation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogSubscriptionPlanVariation other) {
        return this.name.equals(other.name) && this.phases.equals(other.phases) && this.subscriptionPlanId.equals(other.subscriptionPlanId) && this.monthlyBillingAnchorDate.equals(other.monthlyBillingAnchorDate) && this.canProrate.equals(other.canProrate) && this.successorPlanVariationId.equals(other.successorPlanVariationId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases, this.subscriptionPlanId, this.monthlyBillingAnchorDate, this.canProrate, this.successorPlanVariationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Optional<String> successorPlanVariationId = Optional.empty();
        private Optional<Boolean> canProrate = Optional.empty();
        private Optional<Long> monthlyBillingAnchorDate = Optional.empty();
        private Optional<String> subscriptionPlanId = Optional.empty();
        private List<SubscriptionPhase> phases = new ArrayList<SubscriptionPhase>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogSubscriptionPlanVariation other) {
            this.name(other.getName());
            this.phases(other.getPhases());
            this.subscriptionPlanId(other.getSubscriptionPlanId());
            this.monthlyBillingAnchorDate(other.getMonthlyBillingAnchorDate());
            this.canProrate(other.getCanProrate());
            this.successorPlanVariationId(other.getSuccessorPlanVariationId());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage successorPlanVariationId(Nullable<String> successorPlanVariationId) {
            this.successorPlanVariationId = successorPlanVariationId.isNull() ? null : (successorPlanVariationId.isEmpty() ? Optional.empty() : Optional.of(successorPlanVariationId.get()));
            return this;
        }

        @Override
        public _FinalStage successorPlanVariationId(String successorPlanVariationId) {
            this.successorPlanVariationId = Optional.ofNullable(successorPlanVariationId);
            return this;
        }

        @Override
        @JsonSetter(value="successor_plan_variation_id", nulls=Nulls.SKIP)
        public _FinalStage successorPlanVariationId(Optional<String> successorPlanVariationId) {
            this.successorPlanVariationId = successorPlanVariationId;
            return this;
        }

        @Override
        public _FinalStage canProrate(Nullable<Boolean> canProrate) {
            this.canProrate = canProrate.isNull() ? null : (canProrate.isEmpty() ? Optional.empty() : Optional.of(canProrate.get()));
            return this;
        }

        @Override
        public _FinalStage canProrate(Boolean canProrate) {
            this.canProrate = Optional.ofNullable(canProrate);
            return this;
        }

        @Override
        @JsonSetter(value="can_prorate", nulls=Nulls.SKIP)
        public _FinalStage canProrate(Optional<Boolean> canProrate) {
            this.canProrate = canProrate;
            return this;
        }

        @Override
        public _FinalStage monthlyBillingAnchorDate(Nullable<Long> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate.isNull() ? null : (monthlyBillingAnchorDate.isEmpty() ? Optional.empty() : Optional.of(monthlyBillingAnchorDate.get()));
            return this;
        }

        @Override
        public _FinalStage monthlyBillingAnchorDate(Long monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = Optional.ofNullable(monthlyBillingAnchorDate);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_billing_anchor_date", nulls=Nulls.SKIP)
        public _FinalStage monthlyBillingAnchorDate(Optional<Long> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        @Override
        public _FinalStage subscriptionPlanId(Nullable<String> subscriptionPlanId) {
            this.subscriptionPlanId = subscriptionPlanId.isNull() ? null : (subscriptionPlanId.isEmpty() ? Optional.empty() : Optional.of(subscriptionPlanId.get()));
            return this;
        }

        @Override
        public _FinalStage subscriptionPlanId(String subscriptionPlanId) {
            this.subscriptionPlanId = Optional.ofNullable(subscriptionPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="subscription_plan_id", nulls=Nulls.SKIP)
        public _FinalStage subscriptionPlanId(Optional<String> subscriptionPlanId) {
            this.subscriptionPlanId = subscriptionPlanId;
            return this;
        }

        @Override
        public _FinalStage addAllPhases(List<SubscriptionPhase> phases) {
            this.phases.addAll(phases);
            return this;
        }

        @Override
        public _FinalStage addPhases(SubscriptionPhase phases) {
            this.phases.add(phases);
            return this;
        }

        @Override
        @JsonSetter(value="phases", nulls=Nulls.SKIP)
        public _FinalStage phases(List<SubscriptionPhase> phases) {
            this.phases.clear();
            this.phases.addAll(phases);
            return this;
        }

        @Override
        public CatalogSubscriptionPlanVariation build() {
            return new CatalogSubscriptionPlanVariation(this.name, this.phases, this.subscriptionPlanId, this.monthlyBillingAnchorDate, this.canProrate, this.successorPlanVariationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogSubscriptionPlanVariation build();

        public _FinalStage phases(List<SubscriptionPhase> var1);

        public _FinalStage addPhases(SubscriptionPhase var1);

        public _FinalStage addAllPhases(List<SubscriptionPhase> var1);

        public _FinalStage subscriptionPlanId(Optional<String> var1);

        public _FinalStage subscriptionPlanId(String var1);

        public _FinalStage subscriptionPlanId(Nullable<String> var1);

        public _FinalStage monthlyBillingAnchorDate(Optional<Long> var1);

        public _FinalStage monthlyBillingAnchorDate(Long var1);

        public _FinalStage monthlyBillingAnchorDate(Nullable<Long> var1);

        public _FinalStage canProrate(Optional<Boolean> var1);

        public _FinalStage canProrate(Boolean var1);

        public _FinalStage canProrate(Nullable<Boolean> var1);

        public _FinalStage successorPlanVariationId(Optional<String> var1);

        public _FinalStage successorPlanVariationId(String var1);

        public _FinalStage successorPlanVariationId(Nullable<String> var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(CatalogSubscriptionPlanVariation var1);
    }
}

