/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChangeBillingAnchorDateRequest {
    private final String subscriptionId;
    private final Optional<Integer> monthlyBillingAnchorDate;
    private final Optional<String> effectiveDate;
    private final Map<String, Object> additionalProperties;

    private ChangeBillingAnchorDateRequest(String subscriptionId, Optional<Integer> monthlyBillingAnchorDate, Optional<String> effectiveDate, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.effectiveDate = effectiveDate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<Integer> getMonthlyBillingAnchorDate() {
        if (this.monthlyBillingAnchorDate == null) {
            return Optional.empty();
        }
        return this.monthlyBillingAnchorDate;
    }

    @JsonIgnore
    public Optional<String> getEffectiveDate() {
        if (this.effectiveDate == null) {
            return Optional.empty();
        }
        return this.effectiveDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="monthly_billing_anchor_date")
    private Optional<Integer> _getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="effective_date")
    private Optional<String> _getEffectiveDate() {
        return this.effectiveDate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChangeBillingAnchorDateRequest && this.equalTo((ChangeBillingAnchorDateRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChangeBillingAnchorDateRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.monthlyBillingAnchorDate.equals(other.monthlyBillingAnchorDate) && this.effectiveDate.equals(other.effectiveDate);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.monthlyBillingAnchorDate, this.effectiveDate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<String> effectiveDate = Optional.empty();
        private Optional<Integer> monthlyBillingAnchorDate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChangeBillingAnchorDateRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.monthlyBillingAnchorDate(other.getMonthlyBillingAnchorDate());
            this.effectiveDate(other.getEffectiveDate());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage effectiveDate(Nullable<String> effectiveDate) {
            this.effectiveDate = effectiveDate.isNull() ? null : (effectiveDate.isEmpty() ? Optional.empty() : Optional.of(effectiveDate.get()));
            return this;
        }

        @Override
        public _FinalStage effectiveDate(String effectiveDate) {
            this.effectiveDate = Optional.ofNullable(effectiveDate);
            return this;
        }

        @Override
        @JsonSetter(value="effective_date", nulls=Nulls.SKIP)
        public _FinalStage effectiveDate(Optional<String> effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Override
        public _FinalStage monthlyBillingAnchorDate(Nullable<Integer> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate.isNull() ? null : (monthlyBillingAnchorDate.isEmpty() ? Optional.empty() : Optional.of(monthlyBillingAnchorDate.get()));
            return this;
        }

        @Override
        public _FinalStage monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = Optional.ofNullable(monthlyBillingAnchorDate);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_billing_anchor_date", nulls=Nulls.SKIP)
        public _FinalStage monthlyBillingAnchorDate(Optional<Integer> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        @Override
        public ChangeBillingAnchorDateRequest build() {
            return new ChangeBillingAnchorDateRequest(this.subscriptionId, this.monthlyBillingAnchorDate, this.effectiveDate, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChangeBillingAnchorDateRequest build();

        public _FinalStage monthlyBillingAnchorDate(Optional<Integer> var1);

        public _FinalStage monthlyBillingAnchorDate(Integer var1);

        public _FinalStage monthlyBillingAnchorDate(Nullable<Integer> var1);

        public _FinalStage effectiveDate(Optional<String> var1);

        public _FinalStage effectiveDate(String var1);

        public _FinalStage effectiveDate(Nullable<String> var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(ChangeBillingAnchorDateRequest var1);
    }
}

