/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Subscription;
import com.squareup.square.types.SubscriptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChangeBillingAnchorDateResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Subscription> subscription;
    private final Optional<List<SubscriptionAction>> actions;
    private final Map<String, Object> additionalProperties;

    private ChangeBillingAnchorDateResponse(Optional<List<Error>> errors, Optional<Subscription> subscription, Optional<List<SubscriptionAction>> actions, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.subscription = subscription;
        this.actions = actions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="subscription")
    public Optional<Subscription> getSubscription() {
        return this.subscription;
    }

    @JsonProperty(value="actions")
    public Optional<List<SubscriptionAction>> getActions() {
        return this.actions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChangeBillingAnchorDateResponse && this.equalTo((ChangeBillingAnchorDateResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChangeBillingAnchorDateResponse other) {
        return this.errors.equals(other.errors) && this.subscription.equals(other.subscription) && this.actions.equals(other.actions);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscription, this.actions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Subscription> subscription = Optional.empty();
        private Optional<List<SubscriptionAction>> actions = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChangeBillingAnchorDateResponse other) {
            this.errors(other.getErrors());
            this.subscription(other.getSubscription());
            this.actions(other.getActions());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="subscription", nulls=Nulls.SKIP)
        public Builder subscription(Optional<Subscription> subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder subscription(Subscription subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        @JsonSetter(value="actions", nulls=Nulls.SKIP)
        public Builder actions(Optional<List<SubscriptionAction>> actions) {
            this.actions = actions;
            return this;
        }

        public Builder actions(List<SubscriptionAction> actions) {
            this.actions = Optional.ofNullable(actions);
            return this;
        }

        public ChangeBillingAnchorDateResponse build() {
            return new ChangeBillingAnchorDateResponse(this.errors, this.subscription, this.actions, this.additionalProperties);
        }
    }
}

