/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChargeRequestAdditionalRecipient {
    private final String locationId;
    private final String description;
    private final Money amountMoney;
    private final Map<String, Object> additionalProperties;

    private ChargeRequestAdditionalRecipient(String locationId, String description, Money amountMoney, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.description = description;
        this.amountMoney = amountMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChargeRequestAdditionalRecipient && this.equalTo((ChargeRequestAdditionalRecipient)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChargeRequestAdditionalRecipient other) {
        return this.locationId.equals(other.locationId) && this.description.equals(other.description) && this.amountMoney.equals(other.amountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.description, this.amountMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    DescriptionStage,
    AmountMoneyStage,
    _FinalStage {
        private String locationId;
        private String description;
        private Money amountMoney;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChargeRequestAdditionalRecipient other) {
            this.locationId(other.getLocationId());
            this.description(other.getDescription());
            this.amountMoney(other.getAmountMoney());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public DescriptionStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public AmountMoneyStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public _FinalStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        public ChargeRequestAdditionalRecipient build() {
            return new ChargeRequestAdditionalRecipient(this.locationId, this.description, this.amountMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChargeRequestAdditionalRecipient build();
    }

    public static interface AmountMoneyStage {
        public _FinalStage amountMoney(@NotNull Money var1);
    }

    public static interface DescriptionStage {
        public AmountMoneyStage description(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public DescriptionStage locationId(@NotNull String var1);

        public Builder from(ChargeRequestAdditionalRecipient var1);
    }
}

