/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutLocationSettingsBranding;
import com.squareup.square.types.CheckoutLocationSettingsCoupons;
import com.squareup.square.types.CheckoutLocationSettingsPolicy;
import com.squareup.square.types.CheckoutLocationSettingsTipping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutLocationSettings {
    private final Optional<String> locationId;
    private final Optional<Boolean> customerNotesEnabled;
    private final Optional<List<CheckoutLocationSettingsPolicy>> policies;
    private final Optional<CheckoutLocationSettingsBranding> branding;
    private final Optional<CheckoutLocationSettingsTipping> tipping;
    private final Optional<CheckoutLocationSettingsCoupons> coupons;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private CheckoutLocationSettings(Optional<String> locationId, Optional<Boolean> customerNotesEnabled, Optional<List<CheckoutLocationSettingsPolicy>> policies, Optional<CheckoutLocationSettingsBranding> branding, Optional<CheckoutLocationSettingsTipping> tipping, Optional<CheckoutLocationSettingsCoupons> coupons, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.customerNotesEnabled = customerNotesEnabled;
        this.policies = policies;
        this.branding = branding;
        this.tipping = tipping;
        this.coupons = coupons;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<Boolean> getCustomerNotesEnabled() {
        if (this.customerNotesEnabled == null) {
            return Optional.empty();
        }
        return this.customerNotesEnabled;
    }

    @JsonIgnore
    public Optional<List<CheckoutLocationSettingsPolicy>> getPolicies() {
        if (this.policies == null) {
            return Optional.empty();
        }
        return this.policies;
    }

    @JsonProperty(value="branding")
    public Optional<CheckoutLocationSettingsBranding> getBranding() {
        return this.branding;
    }

    @JsonProperty(value="tipping")
    public Optional<CheckoutLocationSettingsTipping> getTipping() {
        return this.tipping;
    }

    @JsonProperty(value="coupons")
    public Optional<CheckoutLocationSettingsCoupons> getCoupons() {
        return this.coupons;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_notes_enabled")
    private Optional<Boolean> _getCustomerNotesEnabled() {
        return this.customerNotesEnabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="policies")
    private Optional<List<CheckoutLocationSettingsPolicy>> _getPolicies() {
        return this.policies;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutLocationSettings && this.equalTo((CheckoutLocationSettings)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutLocationSettings other) {
        return this.locationId.equals(other.locationId) && this.customerNotesEnabled.equals(other.customerNotesEnabled) && this.policies.equals(other.policies) && this.branding.equals(other.branding) && this.tipping.equals(other.tipping) && this.coupons.equals(other.coupons) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.customerNotesEnabled, this.policies, this.branding, this.tipping, this.coupons, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> locationId = Optional.empty();
        private Optional<Boolean> customerNotesEnabled = Optional.empty();
        private Optional<List<CheckoutLocationSettingsPolicy>> policies = Optional.empty();
        private Optional<CheckoutLocationSettingsBranding> branding = Optional.empty();
        private Optional<CheckoutLocationSettingsTipping> tipping = Optional.empty();
        private Optional<CheckoutLocationSettingsCoupons> coupons = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CheckoutLocationSettings other) {
            this.locationId(other.getLocationId());
            this.customerNotesEnabled(other.getCustomerNotesEnabled());
            this.policies(other.getPolicies());
            this.branding(other.getBranding());
            this.tipping(other.getTipping());
            this.coupons(other.getCoupons());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="customer_notes_enabled", nulls=Nulls.SKIP)
        public Builder customerNotesEnabled(Optional<Boolean> customerNotesEnabled) {
            this.customerNotesEnabled = customerNotesEnabled;
            return this;
        }

        public Builder customerNotesEnabled(Boolean customerNotesEnabled) {
            this.customerNotesEnabled = Optional.ofNullable(customerNotesEnabled);
            return this;
        }

        public Builder customerNotesEnabled(Nullable<Boolean> customerNotesEnabled) {
            this.customerNotesEnabled = customerNotesEnabled.isNull() ? null : (customerNotesEnabled.isEmpty() ? Optional.empty() : Optional.of(customerNotesEnabled.get()));
            return this;
        }

        @JsonSetter(value="policies", nulls=Nulls.SKIP)
        public Builder policies(Optional<List<CheckoutLocationSettingsPolicy>> policies) {
            this.policies = policies;
            return this;
        }

        public Builder policies(List<CheckoutLocationSettingsPolicy> policies) {
            this.policies = Optional.ofNullable(policies);
            return this;
        }

        public Builder policies(Nullable<List<CheckoutLocationSettingsPolicy>> policies) {
            this.policies = policies.isNull() ? null : (policies.isEmpty() ? Optional.empty() : Optional.of(policies.get()));
            return this;
        }

        @JsonSetter(value="branding", nulls=Nulls.SKIP)
        public Builder branding(Optional<CheckoutLocationSettingsBranding> branding) {
            this.branding = branding;
            return this;
        }

        public Builder branding(CheckoutLocationSettingsBranding branding) {
            this.branding = Optional.ofNullable(branding);
            return this;
        }

        @JsonSetter(value="tipping", nulls=Nulls.SKIP)
        public Builder tipping(Optional<CheckoutLocationSettingsTipping> tipping) {
            this.tipping = tipping;
            return this;
        }

        public Builder tipping(CheckoutLocationSettingsTipping tipping) {
            this.tipping = Optional.ofNullable(tipping);
            return this;
        }

        @JsonSetter(value="coupons", nulls=Nulls.SKIP)
        public Builder coupons(Optional<CheckoutLocationSettingsCoupons> coupons) {
            this.coupons = coupons;
            return this;
        }

        public Builder coupons(CheckoutLocationSettingsCoupons coupons) {
            this.coupons = Optional.ofNullable(coupons);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public CheckoutLocationSettings build() {
            return new CheckoutLocationSettings(this.locationId, this.customerNotesEnabled, this.policies, this.branding, this.tipping, this.coupons, this.updatedAt, this.additionalProperties);
        }
    }
}

