/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutLocationSettingsPolicy {
    private final Optional<String> uid;
    private final Optional<String> title;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private CheckoutLocationSettingsPolicy(Optional<String> uid, Optional<String> title, Optional<String> description, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.title = title;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<String> getTitle() {
        if (this.title == null) {
            return Optional.empty();
        }
        return this.title;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="title")
    private Optional<String> _getTitle() {
        return this.title;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutLocationSettingsPolicy && this.equalTo((CheckoutLocationSettingsPolicy)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutLocationSettingsPolicy other) {
        return this.uid.equals(other.uid) && this.title.equals(other.title) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.title, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CheckoutLocationSettingsPolicy other) {
            this.uid(other.getUid());
            this.title(other.getTitle());
            this.description(other.getDescription());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        public Builder title(Nullable<String> title) {
            this.title = title.isNull() ? null : (title.isEmpty() ? Optional.empty() : Optional.of(title.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        public CheckoutLocationSettingsPolicy build() {
            return new CheckoutLocationSettingsPolicy(this.uid, this.title, this.description, this.additionalProperties);
        }
    }
}

