/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutMerchantSettingsPaymentMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutMerchantSettings {
    private final Optional<CheckoutMerchantSettingsPaymentMethods> paymentMethods;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private CheckoutMerchantSettings(Optional<CheckoutMerchantSettingsPaymentMethods> paymentMethods, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.paymentMethods = paymentMethods;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment_methods")
    public Optional<CheckoutMerchantSettingsPaymentMethods> getPaymentMethods() {
        return this.paymentMethods;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutMerchantSettings && this.equalTo((CheckoutMerchantSettings)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutMerchantSettings other) {
        return this.paymentMethods.equals(other.paymentMethods) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.paymentMethods, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CheckoutMerchantSettingsPaymentMethods> paymentMethods = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CheckoutMerchantSettings other) {
            this.paymentMethods(other.getPaymentMethods());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="payment_methods", nulls=Nulls.SKIP)
        public Builder paymentMethods(Optional<CheckoutMerchantSettingsPaymentMethods> paymentMethods) {
            this.paymentMethods = paymentMethods;
            return this;
        }

        public Builder paymentMethods(CheckoutMerchantSettingsPaymentMethods paymentMethods) {
            this.paymentMethods = Optional.ofNullable(paymentMethods);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public CheckoutMerchantSettings build() {
            return new CheckoutMerchantSettings(this.paymentMethods, this.updatedAt, this.additionalProperties);
        }
    }
}

