/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ClearpayDetails {
    private final Optional<String> emailAddress;
    private final Map<String, Object> additionalProperties;

    private ClearpayDetails(Optional<String> emailAddress, Map<String, Object> additionalProperties) {
        this.emailAddress = emailAddress;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getEmailAddress() {
        if (this.emailAddress == null) {
            return Optional.empty();
        }
        return this.emailAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address")
    private Optional<String> _getEmailAddress() {
        return this.emailAddress;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClearpayDetails && this.equalTo((ClearpayDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClearpayDetails other) {
        return this.emailAddress.equals(other.emailAddress);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> emailAddress = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ClearpayDetails other) {
            this.emailAddress(other.getEmailAddress());
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Nullable<String> emailAddress) {
            this.emailAddress = emailAddress.isNull() ? null : (emailAddress.isEmpty() ? Optional.empty() : Optional.of(emailAddress.get()));
            return this;
        }

        public ClearpayDetails build() {
            return new ClearpayDetails(this.emailAddress, this.additionalProperties);
        }
    }
}

