/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompletePaymentRequest {
    private final String paymentId;
    private final Optional<String> versionToken;
    private final Map<String, Object> additionalProperties;

    private CompletePaymentRequest(String paymentId, Optional<String> versionToken, Map<String, Object> additionalProperties) {
        this.paymentId = paymentId;
        this.versionToken = versionToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getVersionToken() {
        if (this.versionToken == null) {
            return Optional.empty();
        }
        return this.versionToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="version_token")
    private Optional<String> _getVersionToken() {
        return this.versionToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompletePaymentRequest && this.equalTo((CompletePaymentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompletePaymentRequest other) {
        return this.paymentId.equals(other.paymentId) && this.versionToken.equals(other.versionToken);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.versionToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PaymentIdStage,
    _FinalStage {
        private String paymentId;
        private Optional<String> versionToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompletePaymentRequest other) {
            this.paymentId(other.getPaymentId());
            this.versionToken(other.getVersionToken());
            return this;
        }

        @Override
        @JsonSetter(value="payment_id")
        public _FinalStage paymentId(@NotNull String paymentId) {
            this.paymentId = Objects.requireNonNull(paymentId, "paymentId must not be null");
            return this;
        }

        @Override
        public _FinalStage versionToken(Nullable<String> versionToken) {
            this.versionToken = versionToken.isNull() ? null : (versionToken.isEmpty() ? Optional.empty() : Optional.of(versionToken.get()));
            return this;
        }

        @Override
        public _FinalStage versionToken(String versionToken) {
            this.versionToken = Optional.ofNullable(versionToken);
            return this;
        }

        @Override
        @JsonSetter(value="version_token", nulls=Nulls.SKIP)
        public _FinalStage versionToken(Optional<String> versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        @Override
        public CompletePaymentRequest build() {
            return new CompletePaymentRequest(this.paymentId, this.versionToken, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompletePaymentRequest build();

        public _FinalStage versionToken(Optional<String> var1);

        public _FinalStage versionToken(String var1);

        public _FinalStage versionToken(Nullable<String> var1);
    }

    public static interface PaymentIdStage {
        public _FinalStage paymentId(@NotNull String var1);

        public Builder from(CompletePaymentRequest var1);
    }
}

