/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class ComponentComponentType {
    public static final ComponentComponentType APPLICATION = new ComponentComponentType(Value.APPLICATION, "APPLICATION");
    public static final ComponentComponentType WIFI = new ComponentComponentType(Value.WIFI, "WIFI");
    public static final ComponentComponentType CARD_READER = new ComponentComponentType(Value.CARD_READER, "CARD_READER");
    public static final ComponentComponentType BATTERY = new ComponentComponentType(Value.BATTERY, "BATTERY");
    public static final ComponentComponentType ETHERNET = new ComponentComponentType(Value.ETHERNET, "ETHERNET");
    public static final ComponentComponentType PRINTER = new ComponentComponentType(Value.PRINTER, "PRINTER");
    private final Value value;
    private final String string;

    ComponentComponentType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ComponentComponentType && this.string.equals(((ComponentComponentType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case APPLICATION: {
                return visitor.visitApplication();
            }
            case WIFI: {
                return visitor.visitWifi();
            }
            case CARD_READER: {
                return visitor.visitCardReader();
            }
            case BATTERY: {
                return visitor.visitBattery();
            }
            case ETHERNET: {
                return visitor.visitEthernet();
            }
            case PRINTER: {
                return visitor.visitPrinter();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static ComponentComponentType valueOf(String value) {
        switch (value) {
            case "APPLICATION": {
                return APPLICATION;
            }
            case "WIFI": {
                return WIFI;
            }
            case "CARD_READER": {
                return CARD_READER;
            }
            case "BATTERY": {
                return BATTERY;
            }
            case "ETHERNET": {
                return ETHERNET;
            }
            case "PRINTER": {
                return PRINTER;
            }
        }
        return new ComponentComponentType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitApplication();

        public T visitCardReader();

        public T visitBattery();

        public T visitWifi();

        public T visitEthernet();

        public T visitPrinter();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        APPLICATION,
        CARD_READER,
        BATTERY,
        WIFI,
        ETHERNET,
        PRINTER,
        UNKNOWN;

    }
}

