/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ConfirmationDecision;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConfirmationOptions {
    private final String title;
    private final String body;
    private final String agreeButtonText;
    private final Optional<String> disagreeButtonText;
    private final Optional<ConfirmationDecision> decision;
    private final Map<String, Object> additionalProperties;

    private ConfirmationOptions(String title, String body, String agreeButtonText, Optional<String> disagreeButtonText, Optional<ConfirmationDecision> decision, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.agreeButtonText = agreeButtonText;
        this.disagreeButtonText = disagreeButtonText;
        this.decision = decision;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="agree_button_text")
    public String getAgreeButtonText() {
        return this.agreeButtonText;
    }

    @JsonIgnore
    public Optional<String> getDisagreeButtonText() {
        if (this.disagreeButtonText == null) {
            return Optional.empty();
        }
        return this.disagreeButtonText;
    }

    @JsonProperty(value="decision")
    public Optional<ConfirmationDecision> getDecision() {
        return this.decision;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="disagree_button_text")
    private Optional<String> _getDisagreeButtonText() {
        return this.disagreeButtonText;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConfirmationOptions && this.equalTo((ConfirmationOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConfirmationOptions other) {
        return this.title.equals(other.title) && this.body.equals(other.body) && this.agreeButtonText.equals(other.agreeButtonText) && this.disagreeButtonText.equals(other.disagreeButtonText) && this.decision.equals(other.decision);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.agreeButtonText, this.disagreeButtonText, this.decision);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    BodyStage,
    AgreeButtonTextStage,
    _FinalStage {
        private String title;
        private String body;
        private String agreeButtonText;
        private Optional<ConfirmationDecision> decision = Optional.empty();
        private Optional<String> disagreeButtonText = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConfirmationOptions other) {
            this.title(other.getTitle());
            this.body(other.getBody());
            this.agreeButtonText(other.getAgreeButtonText());
            this.disagreeButtonText(other.getDisagreeButtonText());
            this.decision(other.getDecision());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public BodyStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public AgreeButtonTextStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="agree_button_text")
        public _FinalStage agreeButtonText(@NotNull String agreeButtonText) {
            this.agreeButtonText = Objects.requireNonNull(agreeButtonText, "agreeButtonText must not be null");
            return this;
        }

        @Override
        public _FinalStage decision(ConfirmationDecision decision) {
            this.decision = Optional.ofNullable(decision);
            return this;
        }

        @Override
        @JsonSetter(value="decision", nulls=Nulls.SKIP)
        public _FinalStage decision(Optional<ConfirmationDecision> decision) {
            this.decision = decision;
            return this;
        }

        @Override
        public _FinalStage disagreeButtonText(Nullable<String> disagreeButtonText) {
            this.disagreeButtonText = disagreeButtonText.isNull() ? null : (disagreeButtonText.isEmpty() ? Optional.empty() : Optional.of(disagreeButtonText.get()));
            return this;
        }

        @Override
        public _FinalStage disagreeButtonText(String disagreeButtonText) {
            this.disagreeButtonText = Optional.ofNullable(disagreeButtonText);
            return this;
        }

        @Override
        @JsonSetter(value="disagree_button_text", nulls=Nulls.SKIP)
        public _FinalStage disagreeButtonText(Optional<String> disagreeButtonText) {
            this.disagreeButtonText = disagreeButtonText;
            return this;
        }

        @Override
        public ConfirmationOptions build() {
            return new ConfirmationOptions(this.title, this.body, this.agreeButtonText, this.disagreeButtonText, this.decision, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConfirmationOptions build();

        public _FinalStage disagreeButtonText(Optional<String> var1);

        public _FinalStage disagreeButtonText(String var1);

        public _FinalStage disagreeButtonText(Nullable<String> var1);

        public _FinalStage decision(Optional<ConfirmationDecision> var1);

        public _FinalStage decision(ConfirmationDecision var1);
    }

    public static interface AgreeButtonTextStage {
        public _FinalStage agreeButtonText(@NotNull String var1);
    }

    public static interface BodyStage {
        public AgreeButtonTextStage body(@NotNull String var1);
    }

    public static interface TitleStage {
        public BodyStage title(@NotNull String var1);

        public Builder from(ConfirmationOptions var1);
    }
}

