/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Coordinates {
    private final Optional<Double> latitude;
    private final Optional<Double> longitude;
    private final Map<String, Object> additionalProperties;

    private Coordinates(Optional<Double> latitude, Optional<Double> longitude, Map<String, Object> additionalProperties) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Double> getLatitude() {
        if (this.latitude == null) {
            return Optional.empty();
        }
        return this.latitude;
    }

    @JsonIgnore
    public Optional<Double> getLongitude() {
        if (this.longitude == null) {
            return Optional.empty();
        }
        return this.longitude;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="latitude")
    private Optional<Double> _getLatitude() {
        return this.latitude;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="longitude")
    private Optional<Double> _getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Coordinates && this.equalTo((Coordinates)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Coordinates other) {
        return this.latitude.equals(other.latitude) && this.longitude.equals(other.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Double> latitude = Optional.empty();
        private Optional<Double> longitude = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Coordinates other) {
            this.latitude(other.getLatitude());
            this.longitude(other.getLongitude());
            return this;
        }

        @JsonSetter(value="latitude", nulls=Nulls.SKIP)
        public Builder latitude(Optional<Double> latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder latitude(Double latitude) {
            this.latitude = Optional.ofNullable(latitude);
            return this;
        }

        public Builder latitude(Nullable<Double> latitude) {
            this.latitude = latitude.isNull() ? null : (latitude.isEmpty() ? Optional.empty() : Optional.of(latitude.get()));
            return this;
        }

        @JsonSetter(value="longitude", nulls=Nulls.SKIP)
        public Builder longitude(Optional<Double> longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = Optional.ofNullable(longitude);
            return this;
        }

        public Builder longitude(Nullable<Double> longitude) {
            this.longitude = longitude.isNull() ? null : (longitude.isEmpty() ? Optional.empty() : Optional.of(longitude.get()));
            return this;
        }

        public Coordinates build() {
            return new Coordinates(this.latitude, this.longitude, this.additionalProperties);
        }
    }
}

