/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerGroup;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCustomerGroupResponse {
    private final Optional<List<Error>> errors;
    private final Optional<CustomerGroup> group;
    private final Map<String, Object> additionalProperties;

    private CreateCustomerGroupResponse(Optional<List<Error>> errors, Optional<CustomerGroup> group, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.group = group;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="group")
    public Optional<CustomerGroup> getGroup() {
        return this.group;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCustomerGroupResponse && this.equalTo((CreateCustomerGroupResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCustomerGroupResponse other) {
        return this.errors.equals(other.errors) && this.group.equals(other.group);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.group);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<CustomerGroup> group = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateCustomerGroupResponse other) {
            this.errors(other.getErrors());
            this.group(other.getGroup());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="group", nulls=Nulls.SKIP)
        public Builder group(Optional<CustomerGroup> group) {
            this.group = group;
            return this;
        }

        public Builder group(CustomerGroup group) {
            this.group = Optional.ofNullable(group);
            return this;
        }

        public CreateCustomerGroupResponse build() {
            return new CreateCustomerGroupResponse(this.errors, this.group, this.additionalProperties);
        }
    }
}

