/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.CustomerTaxIds;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCustomerRequest {
    private final Optional<String> idempotencyKey;
    private final Optional<String> givenName;
    private final Optional<String> familyName;
    private final Optional<String> companyName;
    private final Optional<String> nickname;
    private final Optional<String> emailAddress;
    private final Optional<Address> address;
    private final Optional<String> phoneNumber;
    private final Optional<String> referenceId;
    private final Optional<String> note;
    private final Optional<String> birthday;
    private final Optional<CustomerTaxIds> taxIds;
    private final Map<String, Object> additionalProperties;

    private CreateCustomerRequest(Optional<String> idempotencyKey, Optional<String> givenName, Optional<String> familyName, Optional<String> companyName, Optional<String> nickname, Optional<String> emailAddress, Optional<Address> address, Optional<String> phoneNumber, Optional<String> referenceId, Optional<String> note, Optional<String> birthday, Optional<CustomerTaxIds> taxIds, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.givenName = givenName;
        this.familyName = familyName;
        this.companyName = companyName;
        this.nickname = nickname;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.referenceId = referenceId;
        this.note = note;
        this.birthday = birthday;
        this.taxIds = taxIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="given_name")
    public Optional<String> getGivenName() {
        return this.givenName;
    }

    @JsonProperty(value="family_name")
    public Optional<String> getFamilyName() {
        return this.familyName;
    }

    @JsonProperty(value="company_name")
    public Optional<String> getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="nickname")
    public Optional<String> getNickname() {
        return this.nickname;
    }

    @JsonProperty(value="email_address")
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonProperty(value="phone_number")
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="reference_id")
    public Optional<String> getReferenceId() {
        return this.referenceId;
    }

    @JsonProperty(value="note")
    public Optional<String> getNote() {
        return this.note;
    }

    @JsonProperty(value="birthday")
    public Optional<String> getBirthday() {
        return this.birthday;
    }

    @JsonProperty(value="tax_ids")
    public Optional<CustomerTaxIds> getTaxIds() {
        return this.taxIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCustomerRequest && this.equalTo((CreateCustomerRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCustomerRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.givenName.equals(other.givenName) && this.familyName.equals(other.familyName) && this.companyName.equals(other.companyName) && this.nickname.equals(other.nickname) && this.emailAddress.equals(other.emailAddress) && this.address.equals(other.address) && this.phoneNumber.equals(other.phoneNumber) && this.referenceId.equals(other.referenceId) && this.note.equals(other.note) && this.birthday.equals(other.birthday) && this.taxIds.equals(other.taxIds);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.givenName, this.familyName, this.companyName, this.nickname, this.emailAddress, this.address, this.phoneNumber, this.referenceId, this.note, this.birthday, this.taxIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> idempotencyKey = Optional.empty();
        private Optional<String> givenName = Optional.empty();
        private Optional<String> familyName = Optional.empty();
        private Optional<String> companyName = Optional.empty();
        private Optional<String> nickname = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<Address> address = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<String> birthday = Optional.empty();
        private Optional<CustomerTaxIds> taxIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateCustomerRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.givenName(other.getGivenName());
            this.familyName(other.getFamilyName());
            this.companyName(other.getCompanyName());
            this.nickname(other.getNickname());
            this.emailAddress(other.getEmailAddress());
            this.address(other.getAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.referenceId(other.getReferenceId());
            this.note(other.getNote());
            this.birthday(other.getBirthday());
            this.taxIds(other.getTaxIds());
            return this;
        }

        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public Builder idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @JsonSetter(value="given_name", nulls=Nulls.SKIP)
        public Builder givenName(Optional<String> givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = Optional.ofNullable(givenName);
            return this;
        }

        @JsonSetter(value="family_name", nulls=Nulls.SKIP)
        public Builder familyName(Optional<String> familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = Optional.ofNullable(familyName);
            return this;
        }

        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public Builder companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @JsonSetter(value="nickname", nulls=Nulls.SKIP)
        public Builder nickname(Optional<String> nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = Optional.ofNullable(nickname);
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        public Builder address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public Builder note(Optional<String> note) {
            this.note = note;
            return this;
        }

        public Builder note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @JsonSetter(value="birthday", nulls=Nulls.SKIP)
        public Builder birthday(Optional<String> birthday) {
            this.birthday = birthday;
            return this;
        }

        public Builder birthday(String birthday) {
            this.birthday = Optional.ofNullable(birthday);
            return this;
        }

        @JsonSetter(value="tax_ids", nulls=Nulls.SKIP)
        public Builder taxIds(Optional<CustomerTaxIds> taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Builder taxIds(CustomerTaxIds taxIds) {
            this.taxIds = Optional.ofNullable(taxIds);
            return this;
        }

        public CreateCustomerRequest build() {
            return new CreateCustomerRequest(this.idempotencyKey, this.givenName, this.familyName, this.companyName, this.nickname, this.emailAddress, this.address, this.phoneNumber, this.referenceId, this.note, this.birthday, this.taxIds, this.additionalProperties);
        }
    }
}

