/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DisputeEvidenceType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDisputeEvidenceFileRequest {
    private final String idempotencyKey;
    private final Optional<DisputeEvidenceType> evidenceType;
    private final Optional<String> contentType;
    private final Map<String, Object> additionalProperties;

    private CreateDisputeEvidenceFileRequest(String idempotencyKey, Optional<DisputeEvidenceType> evidenceType, Optional<String> contentType, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.evidenceType = evidenceType;
        this.contentType = contentType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="evidence_type")
    public Optional<DisputeEvidenceType> getEvidenceType() {
        return this.evidenceType;
    }

    @JsonProperty(value="content_type")
    public Optional<String> getContentType() {
        return this.contentType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDisputeEvidenceFileRequest && this.equalTo((CreateDisputeEvidenceFileRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDisputeEvidenceFileRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.evidenceType.equals(other.evidenceType) && this.contentType.equals(other.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.evidenceType, this.contentType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    _FinalStage {
        private String idempotencyKey;
        private Optional<String> contentType = Optional.empty();
        private Optional<DisputeEvidenceType> evidenceType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateDisputeEvidenceFileRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.evidenceType(other.getEvidenceType());
            this.contentType(other.getContentType());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        @Override
        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public _FinalStage contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public _FinalStage evidenceType(DisputeEvidenceType evidenceType) {
            this.evidenceType = Optional.ofNullable(evidenceType);
            return this;
        }

        @Override
        @JsonSetter(value="evidence_type", nulls=Nulls.SKIP)
        public _FinalStage evidenceType(Optional<DisputeEvidenceType> evidenceType) {
            this.evidenceType = evidenceType;
            return this;
        }

        @Override
        public CreateDisputeEvidenceFileRequest build() {
            return new CreateDisputeEvidenceFileRequest(this.idempotencyKey, this.evidenceType, this.contentType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateDisputeEvidenceFileRequest build();

        public _FinalStage evidenceType(Optional<DisputeEvidenceType> var1);

        public _FinalStage evidenceType(DisputeEvidenceType var1);

        public _FinalStage contentType(Optional<String> var1);

        public _FinalStage contentType(String var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateDisputeEvidenceFileRequest var1);
    }
}

