/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DisputeEvidence;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDisputeEvidenceFileResponse {
    private final Optional<List<Error>> errors;
    private final Optional<DisputeEvidence> evidence;
    private final Map<String, Object> additionalProperties;

    private CreateDisputeEvidenceFileResponse(Optional<List<Error>> errors, Optional<DisputeEvidence> evidence, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.evidence = evidence;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="evidence")
    public Optional<DisputeEvidence> getEvidence() {
        return this.evidence;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDisputeEvidenceFileResponse && this.equalTo((CreateDisputeEvidenceFileResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDisputeEvidenceFileResponse other) {
        return this.errors.equals(other.errors) && this.evidence.equals(other.evidence);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.evidence);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<DisputeEvidence> evidence = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateDisputeEvidenceFileResponse other) {
            this.errors(other.getErrors());
            this.evidence(other.getEvidence());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="evidence", nulls=Nulls.SKIP)
        public Builder evidence(Optional<DisputeEvidence> evidence) {
            this.evidence = evidence;
            return this;
        }

        public Builder evidence(DisputeEvidence evidence) {
            this.evidence = Optional.ofNullable(evidence);
            return this;
        }

        public CreateDisputeEvidenceFileResponse build() {
            return new CreateDisputeEvidenceFileResponse(this.errors, this.evidence, this.additionalProperties);
        }
    }
}

