/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CreateDisputeEvidenceFileRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateEvidenceFileDisputesRequest {
    private final Optional<File> imageFile;
    private final String disputeId;
    private final Optional<CreateDisputeEvidenceFileRequest> request;
    private final Map<String, Object> additionalProperties;

    private CreateEvidenceFileDisputesRequest(Optional<File> imageFile, String disputeId, Optional<CreateDisputeEvidenceFileRequest> request, Map<String, Object> additionalProperties) {
        this.imageFile = imageFile;
        this.disputeId = disputeId;
        this.request = request;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="image_file")
    public Optional<File> getImageFile() {
        return this.imageFile;
    }

    @JsonProperty(value="dispute_id")
    public String getDisputeId() {
        return this.disputeId;
    }

    @JsonProperty(value="request")
    public Optional<CreateDisputeEvidenceFileRequest> getRequest() {
        return this.request;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateEvidenceFileDisputesRequest && this.equalTo((CreateEvidenceFileDisputesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateEvidenceFileDisputesRequest other) {
        return this.imageFile.equals(other.imageFile) && this.disputeId.equals(other.disputeId) && this.request.equals(other.request);
    }

    public int hashCode() {
        return Objects.hash(this.imageFile, this.disputeId, this.request);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisputeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisputeIdStage,
    _FinalStage {
        private String disputeId;
        private Optional<CreateDisputeEvidenceFileRequest> request = Optional.empty();
        private Optional<File> imageFile = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateEvidenceFileDisputesRequest other) {
            this.imageFile(other.getImageFile());
            this.disputeId(other.getDisputeId());
            this.request(other.getRequest());
            return this;
        }

        @Override
        @JsonSetter(value="dispute_id")
        public _FinalStage disputeId(@NotNull String disputeId) {
            this.disputeId = Objects.requireNonNull(disputeId, "disputeId must not be null");
            return this;
        }

        @Override
        public _FinalStage request(CreateDisputeEvidenceFileRequest request) {
            this.request = Optional.ofNullable(request);
            return this;
        }

        @Override
        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public _FinalStage request(Optional<CreateDisputeEvidenceFileRequest> request) {
            this.request = request;
            return this;
        }

        @Override
        public _FinalStage imageFile(File imageFile) {
            this.imageFile = Optional.ofNullable(imageFile);
            return this;
        }

        @Override
        @JsonSetter(value="image_file", nulls=Nulls.SKIP)
        public _FinalStage imageFile(Optional<File> imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        @Override
        public CreateEvidenceFileDisputesRequest build() {
            return new CreateEvidenceFileDisputesRequest(this.imageFile, this.disputeId, this.request, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateEvidenceFileDisputesRequest build();

        public _FinalStage imageFile(Optional<File> var1);

        public _FinalStage imageFile(File var1);

        public _FinalStage request(Optional<CreateDisputeEvidenceFileRequest> var1);

        public _FinalStage request(CreateDisputeEvidenceFileRequest var1);
    }

    public static interface DisputeIdStage {
        public _FinalStage disputeId(@NotNull String var1);

        public Builder from(CreateEvidenceFileDisputesRequest var1);
    }
}

