/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Job;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateJobRequest {
    private final Job job;
    private final String idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private CreateJobRequest(Job job, String idempotencyKey, Map<String, Object> additionalProperties) {
        this.job = job;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job")
    public Job getJob() {
        return this.job;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateJobRequest && this.equalTo((CreateJobRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateJobRequest other) {
        return this.job.equals(other.job) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.job, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements JobStage,
    IdempotencyKeyStage,
    _FinalStage {
        private Job job;
        private String idempotencyKey;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateJobRequest other) {
            this.job(other.getJob());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="job")
        public IdempotencyKeyStage job(@NotNull Job job) {
            this.job = Objects.requireNonNull(job, "job must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this.job, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateJobRequest build();
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface JobStage {
        public IdempotencyKeyStage job(@NotNull Job var1);

        public Builder from(CreateJobRequest var1);
    }
}

