/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.CashPaymentDetails;
import com.squareup.square.types.CustomerDetails;
import com.squareup.square.types.ExternalPaymentDetails;
import com.squareup.square.types.Money;
import com.squareup.square.types.OfflinePaymentDetails;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreatePaymentRequest {
    private final String sourceId;
    private final String idempotencyKey;
    private final Optional<Money> amountMoney;
    private final Optional<Money> tipMoney;
    private final Optional<Money> appFeeMoney;
    private final Optional<String> delayDuration;
    private final Optional<String> delayAction;
    private final Optional<Boolean> autocomplete;
    private final Optional<String> orderId;
    private final Optional<String> customerId;
    private final Optional<String> locationId;
    private final Optional<String> teamMemberId;
    private final Optional<String> referenceId;
    private final Optional<String> verificationToken;
    private final Optional<Boolean> acceptPartialAuthorization;
    private final Optional<String> buyerEmailAddress;
    private final Optional<String> buyerPhoneNumber;
    private final Optional<Address> billingAddress;
    private final Optional<Address> shippingAddress;
    private final Optional<String> note;
    private final Optional<String> statementDescriptionIdentifier;
    private final Optional<CashPaymentDetails> cashDetails;
    private final Optional<ExternalPaymentDetails> externalDetails;
    private final Optional<CustomerDetails> customerDetails;
    private final Optional<OfflinePaymentDetails> offlinePaymentDetails;
    private final Map<String, Object> additionalProperties;

    private CreatePaymentRequest(String sourceId, String idempotencyKey, Optional<Money> amountMoney, Optional<Money> tipMoney, Optional<Money> appFeeMoney, Optional<String> delayDuration, Optional<String> delayAction, Optional<Boolean> autocomplete, Optional<String> orderId, Optional<String> customerId, Optional<String> locationId, Optional<String> teamMemberId, Optional<String> referenceId, Optional<String> verificationToken, Optional<Boolean> acceptPartialAuthorization, Optional<String> buyerEmailAddress, Optional<String> buyerPhoneNumber, Optional<Address> billingAddress, Optional<Address> shippingAddress, Optional<String> note, Optional<String> statementDescriptionIdentifier, Optional<CashPaymentDetails> cashDetails, Optional<ExternalPaymentDetails> externalDetails, Optional<CustomerDetails> customerDetails, Optional<OfflinePaymentDetails> offlinePaymentDetails, Map<String, Object> additionalProperties) {
        this.sourceId = sourceId;
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.appFeeMoney = appFeeMoney;
        this.delayDuration = delayDuration;
        this.delayAction = delayAction;
        this.autocomplete = autocomplete;
        this.orderId = orderId;
        this.customerId = customerId;
        this.locationId = locationId;
        this.teamMemberId = teamMemberId;
        this.referenceId = referenceId;
        this.verificationToken = verificationToken;
        this.acceptPartialAuthorization = acceptPartialAuthorization;
        this.buyerEmailAddress = buyerEmailAddress;
        this.buyerPhoneNumber = buyerPhoneNumber;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.note = note;
        this.statementDescriptionIdentifier = statementDescriptionIdentifier;
        this.cashDetails = cashDetails;
        this.externalDetails = externalDetails;
        this.customerDetails = customerDetails;
        this.offlinePaymentDetails = offlinePaymentDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="source_id")
    public String getSourceId() {
        return this.sourceId;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="tip_money")
    public Optional<Money> getTipMoney() {
        return this.tipMoney;
    }

    @JsonProperty(value="app_fee_money")
    public Optional<Money> getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonProperty(value="delay_duration")
    public Optional<String> getDelayDuration() {
        return this.delayDuration;
    }

    @JsonProperty(value="delay_action")
    public Optional<String> getDelayAction() {
        return this.delayAction;
    }

    @JsonProperty(value="autocomplete")
    public Optional<Boolean> getAutocomplete() {
        return this.autocomplete;
    }

    @JsonProperty(value="order_id")
    public Optional<String> getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="customer_id")
    public Optional<String> getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="team_member_id")
    public Optional<String> getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonProperty(value="reference_id")
    public Optional<String> getReferenceId() {
        return this.referenceId;
    }

    @JsonProperty(value="verification_token")
    public Optional<String> getVerificationToken() {
        return this.verificationToken;
    }

    @JsonProperty(value="accept_partial_authorization")
    public Optional<Boolean> getAcceptPartialAuthorization() {
        return this.acceptPartialAuthorization;
    }

    @JsonProperty(value="buyer_email_address")
    public Optional<String> getBuyerEmailAddress() {
        return this.buyerEmailAddress;
    }

    @JsonProperty(value="buyer_phone_number")
    public Optional<String> getBuyerPhoneNumber() {
        return this.buyerPhoneNumber;
    }

    @JsonProperty(value="billing_address")
    public Optional<Address> getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="shipping_address")
    public Optional<Address> getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonProperty(value="note")
    public Optional<String> getNote() {
        return this.note;
    }

    @JsonProperty(value="statement_description_identifier")
    public Optional<String> getStatementDescriptionIdentifier() {
        return this.statementDescriptionIdentifier;
    }

    @JsonProperty(value="cash_details")
    public Optional<CashPaymentDetails> getCashDetails() {
        return this.cashDetails;
    }

    @JsonProperty(value="external_details")
    public Optional<ExternalPaymentDetails> getExternalDetails() {
        return this.externalDetails;
    }

    @JsonProperty(value="customer_details")
    public Optional<CustomerDetails> getCustomerDetails() {
        return this.customerDetails;
    }

    @JsonProperty(value="offline_payment_details")
    public Optional<OfflinePaymentDetails> getOfflinePaymentDetails() {
        return this.offlinePaymentDetails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreatePaymentRequest && this.equalTo((CreatePaymentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePaymentRequest other) {
        return this.sourceId.equals(other.sourceId) && this.idempotencyKey.equals(other.idempotencyKey) && this.amountMoney.equals(other.amountMoney) && this.tipMoney.equals(other.tipMoney) && this.appFeeMoney.equals(other.appFeeMoney) && this.delayDuration.equals(other.delayDuration) && this.delayAction.equals(other.delayAction) && this.autocomplete.equals(other.autocomplete) && this.orderId.equals(other.orderId) && this.customerId.equals(other.customerId) && this.locationId.equals(other.locationId) && this.teamMemberId.equals(other.teamMemberId) && this.referenceId.equals(other.referenceId) && this.verificationToken.equals(other.verificationToken) && this.acceptPartialAuthorization.equals(other.acceptPartialAuthorization) && this.buyerEmailAddress.equals(other.buyerEmailAddress) && this.buyerPhoneNumber.equals(other.buyerPhoneNumber) && this.billingAddress.equals(other.billingAddress) && this.shippingAddress.equals(other.shippingAddress) && this.note.equals(other.note) && this.statementDescriptionIdentifier.equals(other.statementDescriptionIdentifier) && this.cashDetails.equals(other.cashDetails) && this.externalDetails.equals(other.externalDetails) && this.customerDetails.equals(other.customerDetails) && this.offlinePaymentDetails.equals(other.offlinePaymentDetails);
    }

    public int hashCode() {
        return Objects.hash(this.sourceId, this.idempotencyKey, this.amountMoney, this.tipMoney, this.appFeeMoney, this.delayDuration, this.delayAction, this.autocomplete, this.orderId, this.customerId, this.locationId, this.teamMemberId, this.referenceId, this.verificationToken, this.acceptPartialAuthorization, this.buyerEmailAddress, this.buyerPhoneNumber, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.cashDetails, this.externalDetails, this.customerDetails, this.offlinePaymentDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SourceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SourceIdStage,
    IdempotencyKeyStage,
    _FinalStage {
        private String sourceId;
        private String idempotencyKey;
        private Optional<OfflinePaymentDetails> offlinePaymentDetails = Optional.empty();
        private Optional<CustomerDetails> customerDetails = Optional.empty();
        private Optional<ExternalPaymentDetails> externalDetails = Optional.empty();
        private Optional<CashPaymentDetails> cashDetails = Optional.empty();
        private Optional<String> statementDescriptionIdentifier = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<Address> shippingAddress = Optional.empty();
        private Optional<Address> billingAddress = Optional.empty();
        private Optional<String> buyerPhoneNumber = Optional.empty();
        private Optional<String> buyerEmailAddress = Optional.empty();
        private Optional<Boolean> acceptPartialAuthorization = Optional.empty();
        private Optional<String> verificationToken = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<Boolean> autocomplete = Optional.empty();
        private Optional<String> delayAction = Optional.empty();
        private Optional<String> delayDuration = Optional.empty();
        private Optional<Money> appFeeMoney = Optional.empty();
        private Optional<Money> tipMoney = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreatePaymentRequest other) {
            this.sourceId(other.getSourceId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.amountMoney(other.getAmountMoney());
            this.tipMoney(other.getTipMoney());
            this.appFeeMoney(other.getAppFeeMoney());
            this.delayDuration(other.getDelayDuration());
            this.delayAction(other.getDelayAction());
            this.autocomplete(other.getAutocomplete());
            this.orderId(other.getOrderId());
            this.customerId(other.getCustomerId());
            this.locationId(other.getLocationId());
            this.teamMemberId(other.getTeamMemberId());
            this.referenceId(other.getReferenceId());
            this.verificationToken(other.getVerificationToken());
            this.acceptPartialAuthorization(other.getAcceptPartialAuthorization());
            this.buyerEmailAddress(other.getBuyerEmailAddress());
            this.buyerPhoneNumber(other.getBuyerPhoneNumber());
            this.billingAddress(other.getBillingAddress());
            this.shippingAddress(other.getShippingAddress());
            this.note(other.getNote());
            this.statementDescriptionIdentifier(other.getStatementDescriptionIdentifier());
            this.cashDetails(other.getCashDetails());
            this.externalDetails(other.getExternalDetails());
            this.customerDetails(other.getCustomerDetails());
            this.offlinePaymentDetails(other.getOfflinePaymentDetails());
            return this;
        }

        @Override
        @JsonSetter(value="source_id")
        public IdempotencyKeyStage sourceId(@NotNull String sourceId) {
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage offlinePaymentDetails(OfflinePaymentDetails offlinePaymentDetails) {
            this.offlinePaymentDetails = Optional.ofNullable(offlinePaymentDetails);
            return this;
        }

        @Override
        @JsonSetter(value="offline_payment_details", nulls=Nulls.SKIP)
        public _FinalStage offlinePaymentDetails(Optional<OfflinePaymentDetails> offlinePaymentDetails) {
            this.offlinePaymentDetails = offlinePaymentDetails;
            return this;
        }

        @Override
        public _FinalStage customerDetails(CustomerDetails customerDetails) {
            this.customerDetails = Optional.ofNullable(customerDetails);
            return this;
        }

        @Override
        @JsonSetter(value="customer_details", nulls=Nulls.SKIP)
        public _FinalStage customerDetails(Optional<CustomerDetails> customerDetails) {
            this.customerDetails = customerDetails;
            return this;
        }

        @Override
        public _FinalStage externalDetails(ExternalPaymentDetails externalDetails) {
            this.externalDetails = Optional.ofNullable(externalDetails);
            return this;
        }

        @Override
        @JsonSetter(value="external_details", nulls=Nulls.SKIP)
        public _FinalStage externalDetails(Optional<ExternalPaymentDetails> externalDetails) {
            this.externalDetails = externalDetails;
            return this;
        }

        @Override
        public _FinalStage cashDetails(CashPaymentDetails cashDetails) {
            this.cashDetails = Optional.ofNullable(cashDetails);
            return this;
        }

        @Override
        @JsonSetter(value="cash_details", nulls=Nulls.SKIP)
        public _FinalStage cashDetails(Optional<CashPaymentDetails> cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        @Override
        public _FinalStage statementDescriptionIdentifier(String statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = Optional.ofNullable(statementDescriptionIdentifier);
            return this;
        }

        @Override
        @JsonSetter(value="statement_description_identifier", nulls=Nulls.SKIP)
        public _FinalStage statementDescriptionIdentifier(Optional<String> statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = statementDescriptionIdentifier;
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public _FinalStage shippingAddress(Address shippingAddress) {
            this.shippingAddress = Optional.ofNullable(shippingAddress);
            return this;
        }

        @Override
        @JsonSetter(value="shipping_address", nulls=Nulls.SKIP)
        public _FinalStage shippingAddress(Optional<Address> shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        @Override
        public _FinalStage billingAddress(Address billingAddress) {
            this.billingAddress = Optional.ofNullable(billingAddress);
            return this;
        }

        @Override
        @JsonSetter(value="billing_address", nulls=Nulls.SKIP)
        public _FinalStage billingAddress(Optional<Address> billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        @Override
        public _FinalStage buyerPhoneNumber(String buyerPhoneNumber) {
            this.buyerPhoneNumber = Optional.ofNullable(buyerPhoneNumber);
            return this;
        }

        @Override
        @JsonSetter(value="buyer_phone_number", nulls=Nulls.SKIP)
        public _FinalStage buyerPhoneNumber(Optional<String> buyerPhoneNumber) {
            this.buyerPhoneNumber = buyerPhoneNumber;
            return this;
        }

        @Override
        public _FinalStage buyerEmailAddress(String buyerEmailAddress) {
            this.buyerEmailAddress = Optional.ofNullable(buyerEmailAddress);
            return this;
        }

        @Override
        @JsonSetter(value="buyer_email_address", nulls=Nulls.SKIP)
        public _FinalStage buyerEmailAddress(Optional<String> buyerEmailAddress) {
            this.buyerEmailAddress = buyerEmailAddress;
            return this;
        }

        @Override
        public _FinalStage acceptPartialAuthorization(Boolean acceptPartialAuthorization) {
            this.acceptPartialAuthorization = Optional.ofNullable(acceptPartialAuthorization);
            return this;
        }

        @Override
        @JsonSetter(value="accept_partial_authorization", nulls=Nulls.SKIP)
        public _FinalStage acceptPartialAuthorization(Optional<Boolean> acceptPartialAuthorization) {
            this.acceptPartialAuthorization = acceptPartialAuthorization;
            return this;
        }

        @Override
        public _FinalStage verificationToken(String verificationToken) {
            this.verificationToken = Optional.ofNullable(verificationToken);
            return this;
        }

        @Override
        @JsonSetter(value="verification_token", nulls=Nulls.SKIP)
        public _FinalStage verificationToken(Optional<String> verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        @Override
        public _FinalStage referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @Override
        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public _FinalStage referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public _FinalStage teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public _FinalStage teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @Override
        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public _FinalStage customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        @Override
        public _FinalStage orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @Override
        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public _FinalStage orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        @Override
        public _FinalStage autocomplete(Boolean autocomplete) {
            this.autocomplete = Optional.ofNullable(autocomplete);
            return this;
        }

        @Override
        @JsonSetter(value="autocomplete", nulls=Nulls.SKIP)
        public _FinalStage autocomplete(Optional<Boolean> autocomplete) {
            this.autocomplete = autocomplete;
            return this;
        }

        @Override
        public _FinalStage delayAction(String delayAction) {
            this.delayAction = Optional.ofNullable(delayAction);
            return this;
        }

        @Override
        @JsonSetter(value="delay_action", nulls=Nulls.SKIP)
        public _FinalStage delayAction(Optional<String> delayAction) {
            this.delayAction = delayAction;
            return this;
        }

        @Override
        public _FinalStage delayDuration(String delayDuration) {
            this.delayDuration = Optional.ofNullable(delayDuration);
            return this;
        }

        @Override
        @JsonSetter(value="delay_duration", nulls=Nulls.SKIP)
        public _FinalStage delayDuration(Optional<String> delayDuration) {
            this.delayDuration = delayDuration;
            return this;
        }

        @Override
        public _FinalStage appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = Optional.ofNullable(appFeeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="app_fee_money", nulls=Nulls.SKIP)
        public _FinalStage appFeeMoney(Optional<Money> appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        @Override
        public _FinalStage tipMoney(Money tipMoney) {
            this.tipMoney = Optional.ofNullable(tipMoney);
            return this;
        }

        @Override
        @JsonSetter(value="tip_money", nulls=Nulls.SKIP)
        public _FinalStage tipMoney(Optional<Money> tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        @Override
        public _FinalStage amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public _FinalStage amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        @Override
        public CreatePaymentRequest build() {
            return new CreatePaymentRequest(this.sourceId, this.idempotencyKey, this.amountMoney, this.tipMoney, this.appFeeMoney, this.delayDuration, this.delayAction, this.autocomplete, this.orderId, this.customerId, this.locationId, this.teamMemberId, this.referenceId, this.verificationToken, this.acceptPartialAuthorization, this.buyerEmailAddress, this.buyerPhoneNumber, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.cashDetails, this.externalDetails, this.customerDetails, this.offlinePaymentDetails, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreatePaymentRequest build();

        public _FinalStage amountMoney(Optional<Money> var1);

        public _FinalStage amountMoney(Money var1);

        public _FinalStage tipMoney(Optional<Money> var1);

        public _FinalStage tipMoney(Money var1);

        public _FinalStage appFeeMoney(Optional<Money> var1);

        public _FinalStage appFeeMoney(Money var1);

        public _FinalStage delayDuration(Optional<String> var1);

        public _FinalStage delayDuration(String var1);

        public _FinalStage delayAction(Optional<String> var1);

        public _FinalStage delayAction(String var1);

        public _FinalStage autocomplete(Optional<Boolean> var1);

        public _FinalStage autocomplete(Boolean var1);

        public _FinalStage orderId(Optional<String> var1);

        public _FinalStage orderId(String var1);

        public _FinalStage customerId(Optional<String> var1);

        public _FinalStage customerId(String var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage teamMemberId(Optional<String> var1);

        public _FinalStage teamMemberId(String var1);

        public _FinalStage referenceId(Optional<String> var1);

        public _FinalStage referenceId(String var1);

        public _FinalStage verificationToken(Optional<String> var1);

        public _FinalStage verificationToken(String var1);

        public _FinalStage acceptPartialAuthorization(Optional<Boolean> var1);

        public _FinalStage acceptPartialAuthorization(Boolean var1);

        public _FinalStage buyerEmailAddress(Optional<String> var1);

        public _FinalStage buyerEmailAddress(String var1);

        public _FinalStage buyerPhoneNumber(Optional<String> var1);

        public _FinalStage buyerPhoneNumber(String var1);

        public _FinalStage billingAddress(Optional<Address> var1);

        public _FinalStage billingAddress(Address var1);

        public _FinalStage shippingAddress(Optional<Address> var1);

        public _FinalStage shippingAddress(Address var1);

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);

        public _FinalStage statementDescriptionIdentifier(Optional<String> var1);

        public _FinalStage statementDescriptionIdentifier(String var1);

        public _FinalStage cashDetails(Optional<CashPaymentDetails> var1);

        public _FinalStage cashDetails(CashPaymentDetails var1);

        public _FinalStage externalDetails(Optional<ExternalPaymentDetails> var1);

        public _FinalStage externalDetails(ExternalPaymentDetails var1);

        public _FinalStage customerDetails(Optional<CustomerDetails> var1);

        public _FinalStage customerDetails(CustomerDetails var1);

        public _FinalStage offlinePaymentDetails(Optional<OfflinePaymentDetails> var1);

        public _FinalStage offlinePaymentDetails(OfflinePaymentDetails var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface SourceIdStage {
        public IdempotencyKeyStage sourceId(@NotNull String var1);

        public Builder from(CreatePaymentRequest var1);
    }
}

