/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.Phase;
import com.squareup.square.types.SubscriptionSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateSubscriptionRequest {
    private final Optional<String> idempotencyKey;
    private final String locationId;
    private final Optional<String> planVariationId;
    private final String customerId;
    private final Optional<String> startDate;
    private final Optional<String> canceledDate;
    private final Optional<String> taxPercentage;
    private final Optional<Money> priceOverrideMoney;
    private final Optional<String> cardId;
    private final Optional<String> timezone;
    private final Optional<SubscriptionSource> source;
    private final Optional<Integer> monthlyBillingAnchorDate;
    private final Optional<List<Phase>> phases;
    private final Map<String, Object> additionalProperties;

    private CreateSubscriptionRequest(Optional<String> idempotencyKey, String locationId, Optional<String> planVariationId, String customerId, Optional<String> startDate, Optional<String> canceledDate, Optional<String> taxPercentage, Optional<Money> priceOverrideMoney, Optional<String> cardId, Optional<String> timezone, Optional<SubscriptionSource> source, Optional<Integer> monthlyBillingAnchorDate, Optional<List<Phase>> phases, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.locationId = locationId;
        this.planVariationId = planVariationId;
        this.customerId = customerId;
        this.startDate = startDate;
        this.canceledDate = canceledDate;
        this.taxPercentage = taxPercentage;
        this.priceOverrideMoney = priceOverrideMoney;
        this.cardId = cardId;
        this.timezone = timezone;
        this.source = source;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.phases = phases;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="plan_variation_id")
    public Optional<String> getPlanVariationId() {
        return this.planVariationId;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="start_date")
    public Optional<String> getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="canceled_date")
    public Optional<String> getCanceledDate() {
        return this.canceledDate;
    }

    @JsonProperty(value="tax_percentage")
    public Optional<String> getTaxPercentage() {
        return this.taxPercentage;
    }

    @JsonProperty(value="price_override_money")
    public Optional<Money> getPriceOverrideMoney() {
        return this.priceOverrideMoney;
    }

    @JsonProperty(value="card_id")
    public Optional<String> getCardId() {
        return this.cardId;
    }

    @JsonProperty(value="timezone")
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="source")
    public Optional<SubscriptionSource> getSource() {
        return this.source;
    }

    @JsonProperty(value="monthly_billing_anchor_date")
    public Optional<Integer> getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonProperty(value="phases")
    public Optional<List<Phase>> getPhases() {
        return this.phases;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateSubscriptionRequest && this.equalTo((CreateSubscriptionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateSubscriptionRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.locationId.equals(other.locationId) && this.planVariationId.equals(other.planVariationId) && this.customerId.equals(other.customerId) && this.startDate.equals(other.startDate) && this.canceledDate.equals(other.canceledDate) && this.taxPercentage.equals(other.taxPercentage) && this.priceOverrideMoney.equals(other.priceOverrideMoney) && this.cardId.equals(other.cardId) && this.timezone.equals(other.timezone) && this.source.equals(other.source) && this.monthlyBillingAnchorDate.equals(other.monthlyBillingAnchorDate) && this.phases.equals(other.phases);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.locationId, this.planVariationId, this.customerId, this.startDate, this.canceledDate, this.taxPercentage, this.priceOverrideMoney, this.cardId, this.timezone, this.source, this.monthlyBillingAnchorDate, this.phases);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    CustomerIdStage,
    _FinalStage {
        private String locationId;
        private String customerId;
        private Optional<List<Phase>> phases = Optional.empty();
        private Optional<Integer> monthlyBillingAnchorDate = Optional.empty();
        private Optional<SubscriptionSource> source = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        private Optional<String> cardId = Optional.empty();
        private Optional<Money> priceOverrideMoney = Optional.empty();
        private Optional<String> taxPercentage = Optional.empty();
        private Optional<String> canceledDate = Optional.empty();
        private Optional<String> startDate = Optional.empty();
        private Optional<String> planVariationId = Optional.empty();
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateSubscriptionRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.locationId(other.getLocationId());
            this.planVariationId(other.getPlanVariationId());
            this.customerId(other.getCustomerId());
            this.startDate(other.getStartDate());
            this.canceledDate(other.getCanceledDate());
            this.taxPercentage(other.getTaxPercentage());
            this.priceOverrideMoney(other.getPriceOverrideMoney());
            this.cardId(other.getCardId());
            this.timezone(other.getTimezone());
            this.source(other.getSource());
            this.monthlyBillingAnchorDate(other.getMonthlyBillingAnchorDate());
            this.phases(other.getPhases());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public CustomerIdStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public _FinalStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        public _FinalStage phases(List<Phase> phases) {
            this.phases = Optional.ofNullable(phases);
            return this;
        }

        @Override
        @JsonSetter(value="phases", nulls=Nulls.SKIP)
        public _FinalStage phases(Optional<List<Phase>> phases) {
            this.phases = phases;
            return this;
        }

        @Override
        public _FinalStage monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = Optional.ofNullable(monthlyBillingAnchorDate);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_billing_anchor_date", nulls=Nulls.SKIP)
        public _FinalStage monthlyBillingAnchorDate(Optional<Integer> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        @Override
        public _FinalStage source(SubscriptionSource source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @Override
        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public _FinalStage source(Optional<SubscriptionSource> source) {
            this.source = source;
            return this;
        }

        @Override
        public _FinalStage timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        @Override
        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public _FinalStage timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public _FinalStage cardId(String cardId) {
            this.cardId = Optional.ofNullable(cardId);
            return this;
        }

        @Override
        @JsonSetter(value="card_id", nulls=Nulls.SKIP)
        public _FinalStage cardId(Optional<String> cardId) {
            this.cardId = cardId;
            return this;
        }

        @Override
        public _FinalStage priceOverrideMoney(Money priceOverrideMoney) {
            this.priceOverrideMoney = Optional.ofNullable(priceOverrideMoney);
            return this;
        }

        @Override
        @JsonSetter(value="price_override_money", nulls=Nulls.SKIP)
        public _FinalStage priceOverrideMoney(Optional<Money> priceOverrideMoney) {
            this.priceOverrideMoney = priceOverrideMoney;
            return this;
        }

        @Override
        public _FinalStage taxPercentage(String taxPercentage) {
            this.taxPercentage = Optional.ofNullable(taxPercentage);
            return this;
        }

        @Override
        @JsonSetter(value="tax_percentage", nulls=Nulls.SKIP)
        public _FinalStage taxPercentage(Optional<String> taxPercentage) {
            this.taxPercentage = taxPercentage;
            return this;
        }

        @Override
        public _FinalStage canceledDate(String canceledDate) {
            this.canceledDate = Optional.ofNullable(canceledDate);
            return this;
        }

        @Override
        @JsonSetter(value="canceled_date", nulls=Nulls.SKIP)
        public _FinalStage canceledDate(Optional<String> canceledDate) {
            this.canceledDate = canceledDate;
            return this;
        }

        @Override
        public _FinalStage startDate(String startDate) {
            this.startDate = Optional.ofNullable(startDate);
            return this;
        }

        @Override
        @JsonSetter(value="start_date", nulls=Nulls.SKIP)
        public _FinalStage startDate(Optional<String> startDate) {
            this.startDate = startDate;
            return this;
        }

        @Override
        public _FinalStage planVariationId(String planVariationId) {
            this.planVariationId = Optional.ofNullable(planVariationId);
            return this;
        }

        @Override
        @JsonSetter(value="plan_variation_id", nulls=Nulls.SKIP)
        public _FinalStage planVariationId(Optional<String> planVariationId) {
            this.planVariationId = planVariationId;
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateSubscriptionRequest build() {
            return new CreateSubscriptionRequest(this.idempotencyKey, this.locationId, this.planVariationId, this.customerId, this.startDate, this.canceledDate, this.taxPercentage, this.priceOverrideMoney, this.cardId, this.timezone, this.source, this.monthlyBillingAnchorDate, this.phases, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateSubscriptionRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage planVariationId(Optional<String> var1);

        public _FinalStage planVariationId(String var1);

        public _FinalStage startDate(Optional<String> var1);

        public _FinalStage startDate(String var1);

        public _FinalStage canceledDate(Optional<String> var1);

        public _FinalStage canceledDate(String var1);

        public _FinalStage taxPercentage(Optional<String> var1);

        public _FinalStage taxPercentage(String var1);

        public _FinalStage priceOverrideMoney(Optional<Money> var1);

        public _FinalStage priceOverrideMoney(Money var1);

        public _FinalStage cardId(Optional<String> var1);

        public _FinalStage cardId(String var1);

        public _FinalStage timezone(Optional<String> var1);

        public _FinalStage timezone(String var1);

        public _FinalStage source(Optional<SubscriptionSource> var1);

        public _FinalStage source(SubscriptionSource var1);

        public _FinalStage monthlyBillingAnchorDate(Optional<Integer> var1);

        public _FinalStage monthlyBillingAnchorDate(Integer var1);

        public _FinalStage phases(Optional<List<Phase>> var1);

        public _FinalStage phases(List<Phase> var1);
    }

    public static interface CustomerIdStage {
        public _FinalStage customerId(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public CustomerIdStage locationId(@NotNull String var1);

        public Builder from(CreateSubscriptionRequest var1);
    }
}

