/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Subscription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateSubscriptionResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Subscription> subscription;
    private final Map<String, Object> additionalProperties;

    private CreateSubscriptionResponse(Optional<List<Error>> errors, Optional<Subscription> subscription, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.subscription = subscription;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="subscription")
    public Optional<Subscription> getSubscription() {
        return this.subscription;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateSubscriptionResponse && this.equalTo((CreateSubscriptionResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateSubscriptionResponse other) {
        return this.errors.equals(other.errors) && this.subscription.equals(other.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscription);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Subscription> subscription = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateSubscriptionResponse other) {
            this.errors(other.getErrors());
            this.subscription(other.getSubscription());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="subscription", nulls=Nulls.SKIP)
        public Builder subscription(Optional<Subscription> subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder subscription(Subscription subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        public CreateSubscriptionResponse build() {
            return new CreateSubscriptionResponse(this.errors, this.subscription, this.additionalProperties);
        }
    }
}

