/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Timecard;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTimecardRequest {
    private final Optional<String> idempotencyKey;
    private final Timecard timecard;
    private final Map<String, Object> additionalProperties;

    private CreateTimecardRequest(Optional<String> idempotencyKey, Timecard timecard, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.timecard = timecard;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="timecard")
    public Timecard getTimecard() {
        return this.timecard;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTimecardRequest && this.equalTo((CreateTimecardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTimecardRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.timecard.equals(other.timecard);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.timecard);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TimecardStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TimecardStage,
    _FinalStage {
        private Timecard timecard;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTimecardRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.timecard(other.getTimecard());
            return this;
        }

        @Override
        @JsonSetter(value="timecard")
        public _FinalStage timecard(@NotNull Timecard timecard) {
            this.timecard = Objects.requireNonNull(timecard, "timecard must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateTimecardRequest build() {
            return new CreateTimecardRequest(this.idempotencyKey, this.timecard, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTimecardRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface TimecardStage {
        public _FinalStage timecard(@NotNull Timecard var1);

        public Builder from(CreateTimecardRequest var1);
    }
}

