/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Vendor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateVendorResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Vendor> vendor;
    private final Map<String, Object> additionalProperties;

    private CreateVendorResponse(Optional<List<Error>> errors, Optional<Vendor> vendor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.vendor = vendor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="vendor")
    public Optional<Vendor> getVendor() {
        return this.vendor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateVendorResponse && this.equalTo((CreateVendorResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateVendorResponse other) {
        return this.errors.equals(other.errors) && this.vendor.equals(other.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.vendor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Vendor> vendor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateVendorResponse other) {
            this.errors(other.getErrors());
            this.vendor(other.getVendor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="vendor", nulls=Nulls.SKIP)
        public Builder vendor(Optional<Vendor> vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder vendor(Vendor vendor) {
            this.vendor = Optional.ofNullable(vendor);
            return this;
        }

        public CreateVendorResponse build() {
            return new CreateVendorResponse(this.errors, this.vendor, this.additionalProperties);
        }
    }
}

