/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.CustomAttributeDefinitionVisibility;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomAttribute {
    private final Optional<String> key;
    private final Optional<Object> value;
    private final Optional<Integer> version;
    private final Optional<CustomAttributeDefinitionVisibility> visibility;
    private final Optional<CustomAttributeDefinition> definition;
    private final Optional<String> updatedAt;
    private final Optional<String> createdAt;
    private final Map<String, Object> additionalProperties;

    private CustomAttribute(Optional<String> key, Optional<Object> value, Optional<Integer> version, Optional<CustomAttributeDefinitionVisibility> visibility, Optional<CustomAttributeDefinition> definition, Optional<String> updatedAt, Optional<String> createdAt, Map<String, Object> additionalProperties) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.visibility = visibility;
        this.definition = definition;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getKey() {
        if (this.key == null) {
            return Optional.empty();
        }
        return this.key;
    }

    @JsonProperty(value="value")
    public Optional<Object> getValue() {
        return this.value;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="visibility")
    public Optional<CustomAttributeDefinitionVisibility> getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="definition")
    public Optional<CustomAttributeDefinition> getDefinition() {
        return this.definition;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="key")
    private Optional<String> _getKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomAttribute && this.equalTo((CustomAttribute)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomAttribute other) {
        return this.key.equals(other.key) && this.value.equals(other.value) && this.version.equals(other.version) && this.visibility.equals(other.visibility) && this.definition.equals(other.definition) && this.updatedAt.equals(other.updatedAt) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.version, this.visibility, this.definition, this.updatedAt, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> key = Optional.empty();
        private Optional<Object> value = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<CustomAttributeDefinitionVisibility> visibility = Optional.empty();
        private Optional<CustomAttributeDefinition> definition = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomAttribute other) {
            this.key(other.getKey());
            this.value(other.getValue());
            this.version(other.getVersion());
            this.visibility(other.getVisibility());
            this.definition(other.getDefinition());
            this.updatedAt(other.getUpdatedAt());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public Builder key(Optional<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        public Builder key(Nullable<String> key) {
            this.key = key.isNull() ? null : (key.isEmpty() ? Optional.empty() : Optional.of(key.get()));
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<Object> value) {
            this.value = value;
            return this;
        }

        public Builder value(Object value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="visibility", nulls=Nulls.SKIP)
        public Builder visibility(Optional<CustomAttributeDefinitionVisibility> visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder visibility(CustomAttributeDefinitionVisibility visibility) {
            this.visibility = Optional.ofNullable(visibility);
            return this;
        }

        @JsonSetter(value="definition", nulls=Nulls.SKIP)
        public Builder definition(Optional<CustomAttributeDefinition> definition) {
            this.definition = definition;
            return this;
        }

        public Builder definition(CustomAttributeDefinition definition) {
            this.definition = Optional.ofNullable(definition);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public CustomAttribute build() {
            return new CustomAttribute(this.key, this.value, this.version, this.visibility, this.definition, this.updatedAt, this.createdAt, this.additionalProperties);
        }
    }
}

