/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Range;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomAttributeFilter {
    private final Optional<String> customAttributeDefinitionId;
    private final Optional<String> key;
    private final Optional<String> stringFilter;
    private final Optional<Range> numberFilter;
    private final Optional<List<String>> selectionUidsFilter;
    private final Optional<Boolean> boolFilter;
    private final Map<String, Object> additionalProperties;

    private CustomAttributeFilter(Optional<String> customAttributeDefinitionId, Optional<String> key, Optional<String> stringFilter, Optional<Range> numberFilter, Optional<List<String>> selectionUidsFilter, Optional<Boolean> boolFilter, Map<String, Object> additionalProperties) {
        this.customAttributeDefinitionId = customAttributeDefinitionId;
        this.key = key;
        this.stringFilter = stringFilter;
        this.numberFilter = numberFilter;
        this.selectionUidsFilter = selectionUidsFilter;
        this.boolFilter = boolFilter;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCustomAttributeDefinitionId() {
        if (this.customAttributeDefinitionId == null) {
            return Optional.empty();
        }
        return this.customAttributeDefinitionId;
    }

    @JsonIgnore
    public Optional<String> getKey() {
        if (this.key == null) {
            return Optional.empty();
        }
        return this.key;
    }

    @JsonIgnore
    public Optional<String> getStringFilter() {
        if (this.stringFilter == null) {
            return Optional.empty();
        }
        return this.stringFilter;
    }

    @JsonProperty(value="number_filter")
    public Optional<Range> getNumberFilter() {
        return this.numberFilter;
    }

    @JsonIgnore
    public Optional<List<String>> getSelectionUidsFilter() {
        if (this.selectionUidsFilter == null) {
            return Optional.empty();
        }
        return this.selectionUidsFilter;
    }

    @JsonIgnore
    public Optional<Boolean> getBoolFilter() {
        if (this.boolFilter == null) {
            return Optional.empty();
        }
        return this.boolFilter;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="custom_attribute_definition_id")
    private Optional<String> _getCustomAttributeDefinitionId() {
        return this.customAttributeDefinitionId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="key")
    private Optional<String> _getKey() {
        return this.key;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="string_filter")
    private Optional<String> _getStringFilter() {
        return this.stringFilter;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="selection_uids_filter")
    private Optional<List<String>> _getSelectionUidsFilter() {
        return this.selectionUidsFilter;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bool_filter")
    private Optional<Boolean> _getBoolFilter() {
        return this.boolFilter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomAttributeFilter && this.equalTo((CustomAttributeFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomAttributeFilter other) {
        return this.customAttributeDefinitionId.equals(other.customAttributeDefinitionId) && this.key.equals(other.key) && this.stringFilter.equals(other.stringFilter) && this.numberFilter.equals(other.numberFilter) && this.selectionUidsFilter.equals(other.selectionUidsFilter) && this.boolFilter.equals(other.boolFilter);
    }

    public int hashCode() {
        return Objects.hash(this.customAttributeDefinitionId, this.key, this.stringFilter, this.numberFilter, this.selectionUidsFilter, this.boolFilter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> customAttributeDefinitionId = Optional.empty();
        private Optional<String> key = Optional.empty();
        private Optional<String> stringFilter = Optional.empty();
        private Optional<Range> numberFilter = Optional.empty();
        private Optional<List<String>> selectionUidsFilter = Optional.empty();
        private Optional<Boolean> boolFilter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomAttributeFilter other) {
            this.customAttributeDefinitionId(other.getCustomAttributeDefinitionId());
            this.key(other.getKey());
            this.stringFilter(other.getStringFilter());
            this.numberFilter(other.getNumberFilter());
            this.selectionUidsFilter(other.getSelectionUidsFilter());
            this.boolFilter(other.getBoolFilter());
            return this;
        }

        @JsonSetter(value="custom_attribute_definition_id", nulls=Nulls.SKIP)
        public Builder customAttributeDefinitionId(Optional<String> customAttributeDefinitionId) {
            this.customAttributeDefinitionId = customAttributeDefinitionId;
            return this;
        }

        public Builder customAttributeDefinitionId(String customAttributeDefinitionId) {
            this.customAttributeDefinitionId = Optional.ofNullable(customAttributeDefinitionId);
            return this;
        }

        public Builder customAttributeDefinitionId(Nullable<String> customAttributeDefinitionId) {
            this.customAttributeDefinitionId = customAttributeDefinitionId.isNull() ? null : (customAttributeDefinitionId.isEmpty() ? Optional.empty() : Optional.of(customAttributeDefinitionId.get()));
            return this;
        }

        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public Builder key(Optional<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        public Builder key(Nullable<String> key) {
            this.key = key.isNull() ? null : (key.isEmpty() ? Optional.empty() : Optional.of(key.get()));
            return this;
        }

        @JsonSetter(value="string_filter", nulls=Nulls.SKIP)
        public Builder stringFilter(Optional<String> stringFilter) {
            this.stringFilter = stringFilter;
            return this;
        }

        public Builder stringFilter(String stringFilter) {
            this.stringFilter = Optional.ofNullable(stringFilter);
            return this;
        }

        public Builder stringFilter(Nullable<String> stringFilter) {
            this.stringFilter = stringFilter.isNull() ? null : (stringFilter.isEmpty() ? Optional.empty() : Optional.of(stringFilter.get()));
            return this;
        }

        @JsonSetter(value="number_filter", nulls=Nulls.SKIP)
        public Builder numberFilter(Optional<Range> numberFilter) {
            this.numberFilter = numberFilter;
            return this;
        }

        public Builder numberFilter(Range numberFilter) {
            this.numberFilter = Optional.ofNullable(numberFilter);
            return this;
        }

        @JsonSetter(value="selection_uids_filter", nulls=Nulls.SKIP)
        public Builder selectionUidsFilter(Optional<List<String>> selectionUidsFilter) {
            this.selectionUidsFilter = selectionUidsFilter;
            return this;
        }

        public Builder selectionUidsFilter(List<String> selectionUidsFilter) {
            this.selectionUidsFilter = Optional.ofNullable(selectionUidsFilter);
            return this;
        }

        public Builder selectionUidsFilter(Nullable<List<String>> selectionUidsFilter) {
            this.selectionUidsFilter = selectionUidsFilter.isNull() ? null : (selectionUidsFilter.isEmpty() ? Optional.empty() : Optional.of(selectionUidsFilter.get()));
            return this;
        }

        @JsonSetter(value="bool_filter", nulls=Nulls.SKIP)
        public Builder boolFilter(Optional<Boolean> boolFilter) {
            this.boolFilter = boolFilter;
            return this;
        }

        public Builder boolFilter(Boolean boolFilter) {
            this.boolFilter = Optional.ofNullable(boolFilter);
            return this;
        }

        public Builder boolFilter(Nullable<Boolean> boolFilter) {
            this.boolFilter = boolFilter.isNull() ? null : (boolFilter.isEmpty() ? Optional.empty() : Optional.of(boolFilter.get()));
            return this;
        }

        public CustomAttributeFilter build() {
            return new CustomAttributeFilter(this.customAttributeDefinitionId, this.key, this.stringFilter, this.numberFilter, this.selectionUidsFilter, this.boolFilter, this.additionalProperties);
        }
    }
}

