/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Country;
import com.squareup.square.types.CustomerTextFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerAddressFilter {
    private final Optional<CustomerTextFilter> postalCode;
    private final Optional<Country> country;
    private final Map<String, Object> additionalProperties;

    private CustomerAddressFilter(Optional<CustomerTextFilter> postalCode, Optional<Country> country, Map<String, Object> additionalProperties) {
        this.postalCode = postalCode;
        this.country = country;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="postal_code")
    public Optional<CustomerTextFilter> getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="country")
    public Optional<Country> getCountry() {
        return this.country;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerAddressFilter && this.equalTo((CustomerAddressFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerAddressFilter other) {
        return this.postalCode.equals(other.postalCode) && this.country.equals(other.country);
    }

    public int hashCode() {
        return Objects.hash(this.postalCode, this.country);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CustomerTextFilter> postalCode = Optional.empty();
        private Optional<Country> country = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerAddressFilter other) {
            this.postalCode(other.getPostalCode());
            this.country(other.getCountry());
            return this;
        }

        @JsonSetter(value="postal_code", nulls=Nulls.SKIP)
        public Builder postalCode(Optional<CustomerTextFilter> postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder postalCode(CustomerTextFilter postalCode) {
            this.postalCode = Optional.ofNullable(postalCode);
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<Country> country) {
            this.country = country;
            return this;
        }

        public Builder country(Country country) {
            this.country = Optional.ofNullable(country);
            return this;
        }

        public CustomerAddressFilter build() {
            return new CustomerAddressFilter(this.postalCode, this.country, this.additionalProperties);
        }
    }
}

