/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerAddressFilter;
import com.squareup.square.types.CustomerTextFilter;
import com.squareup.square.types.FilterValue;
import com.squareup.square.types.FloatNumberRange;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerCustomAttributeFilterValue {
    private final Optional<CustomerTextFilter> email;
    private final Optional<CustomerTextFilter> phone;
    private final Optional<CustomerTextFilter> text;
    private final Optional<FilterValue> selection;
    private final Optional<TimeRange> date;
    private final Optional<FloatNumberRange> number;
    private final Optional<Boolean> boolean_;
    private final Optional<CustomerAddressFilter> address;
    private final Map<String, Object> additionalProperties;

    private CustomerCustomAttributeFilterValue(Optional<CustomerTextFilter> email, Optional<CustomerTextFilter> phone, Optional<CustomerTextFilter> text, Optional<FilterValue> selection, Optional<TimeRange> date, Optional<FloatNumberRange> number, Optional<Boolean> boolean_, Optional<CustomerAddressFilter> address, Map<String, Object> additionalProperties) {
        this.email = email;
        this.phone = phone;
        this.text = text;
        this.selection = selection;
        this.date = date;
        this.number = number;
        this.boolean_ = boolean_;
        this.address = address;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="email")
    public Optional<CustomerTextFilter> getEmail() {
        return this.email;
    }

    @JsonProperty(value="phone")
    public Optional<CustomerTextFilter> getPhone() {
        return this.phone;
    }

    @JsonProperty(value="text")
    public Optional<CustomerTextFilter> getText() {
        return this.text;
    }

    @JsonProperty(value="selection")
    public Optional<FilterValue> getSelection() {
        return this.selection;
    }

    @JsonProperty(value="date")
    public Optional<TimeRange> getDate() {
        return this.date;
    }

    @JsonProperty(value="number")
    public Optional<FloatNumberRange> getNumber() {
        return this.number;
    }

    @JsonIgnore
    public Optional<Boolean> getBoolean() {
        if (this.boolean_ == null) {
            return Optional.empty();
        }
        return this.boolean_;
    }

    @JsonProperty(value="address")
    public Optional<CustomerAddressFilter> getAddress() {
        return this.address;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="boolean")
    private Optional<Boolean> _getBoolean() {
        return this.boolean_;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerCustomAttributeFilterValue && this.equalTo((CustomerCustomAttributeFilterValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerCustomAttributeFilterValue other) {
        return this.email.equals(other.email) && this.phone.equals(other.phone) && this.text.equals(other.text) && this.selection.equals(other.selection) && this.date.equals(other.date) && this.number.equals(other.number) && this.boolean_.equals(other.boolean_) && this.address.equals(other.address);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.phone, this.text, this.selection, this.date, this.number, this.boolean_, this.address);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CustomerTextFilter> email = Optional.empty();
        private Optional<CustomerTextFilter> phone = Optional.empty();
        private Optional<CustomerTextFilter> text = Optional.empty();
        private Optional<FilterValue> selection = Optional.empty();
        private Optional<TimeRange> date = Optional.empty();
        private Optional<FloatNumberRange> number = Optional.empty();
        private Optional<Boolean> boolean_ = Optional.empty();
        private Optional<CustomerAddressFilter> address = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerCustomAttributeFilterValue other) {
            this.email(other.getEmail());
            this.phone(other.getPhone());
            this.text(other.getText());
            this.selection(other.getSelection());
            this.date(other.getDate());
            this.number(other.getNumber());
            this.boolean_(other.getBoolean());
            this.address(other.getAddress());
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<CustomerTextFilter> email) {
            this.email = email;
            return this;
        }

        public Builder email(CustomerTextFilter email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonSetter(value="phone", nulls=Nulls.SKIP)
        public Builder phone(Optional<CustomerTextFilter> phone) {
            this.phone = phone;
            return this;
        }

        public Builder phone(CustomerTextFilter phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        @JsonSetter(value="text", nulls=Nulls.SKIP)
        public Builder text(Optional<CustomerTextFilter> text) {
            this.text = text;
            return this;
        }

        public Builder text(CustomerTextFilter text) {
            this.text = Optional.ofNullable(text);
            return this;
        }

        @JsonSetter(value="selection", nulls=Nulls.SKIP)
        public Builder selection(Optional<FilterValue> selection) {
            this.selection = selection;
            return this;
        }

        public Builder selection(FilterValue selection) {
            this.selection = Optional.ofNullable(selection);
            return this;
        }

        @JsonSetter(value="date", nulls=Nulls.SKIP)
        public Builder date(Optional<TimeRange> date) {
            this.date = date;
            return this;
        }

        public Builder date(TimeRange date) {
            this.date = Optional.ofNullable(date);
            return this;
        }

        @JsonSetter(value="number", nulls=Nulls.SKIP)
        public Builder number(Optional<FloatNumberRange> number) {
            this.number = number;
            return this;
        }

        public Builder number(FloatNumberRange number) {
            this.number = Optional.ofNullable(number);
            return this;
        }

        @JsonSetter(value="boolean", nulls=Nulls.SKIP)
        public Builder boolean_(Optional<Boolean> boolean_) {
            this.boolean_ = boolean_;
            return this;
        }

        public Builder boolean_(Boolean boolean_) {
            this.boolean_ = Optional.ofNullable(boolean_);
            return this;
        }

        public Builder boolean_(Nullable<Boolean> boolean_) {
            this.boolean_ = boolean_.isNull() ? null : (boolean_.isEmpty() ? Optional.empty() : Optional.of(boolean_.get()));
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<CustomerAddressFilter> address) {
            this.address = address;
            return this;
        }

        public Builder address(CustomerAddressFilter address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        public CustomerCustomAttributeFilterValue build() {
            return new CustomerCustomAttributeFilterValue(this.email, this.phone, this.text, this.selection, this.date, this.number, this.boolean_, this.address, this.additionalProperties);
        }
    }
}

