/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerSortField;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerSort {
    private final Optional<CustomerSortField> field;
    private final Optional<SortOrder> order;
    private final Map<String, Object> additionalProperties;

    private CustomerSort(Optional<CustomerSortField> field, Optional<SortOrder> order, Map<String, Object> additionalProperties) {
        this.field = field;
        this.order = order;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="field")
    public Optional<CustomerSortField> getField() {
        return this.field;
    }

    @JsonProperty(value="order")
    public Optional<SortOrder> getOrder() {
        return this.order;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerSort && this.equalTo((CustomerSort)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerSort other) {
        return this.field.equals(other.field) && this.order.equals(other.order);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.order);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CustomerSortField> field = Optional.empty();
        private Optional<SortOrder> order = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerSort other) {
            this.field(other.getField());
            this.order(other.getOrder());
            return this;
        }

        @JsonSetter(value="field", nulls=Nulls.SKIP)
        public Builder field(Optional<CustomerSortField> field) {
            this.field = field;
            return this;
        }

        public Builder field(CustomerSortField field) {
            this.field = Optional.ofNullable(field);
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<SortOrder> order) {
            this.order = order;
            return this;
        }

        public Builder order(SortOrder order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        public CustomerSort build() {
            return new CustomerSort(this.field, this.order, this.additionalProperties);
        }
    }
}

