/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerTaxIds {
    private final Optional<String> euVat;
    private final Map<String, Object> additionalProperties;

    private CustomerTaxIds(Optional<String> euVat, Map<String, Object> additionalProperties) {
        this.euVat = euVat;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getEuVat() {
        if (this.euVat == null) {
            return Optional.empty();
        }
        return this.euVat;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="eu_vat")
    private Optional<String> _getEuVat() {
        return this.euVat;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerTaxIds && this.equalTo((CustomerTaxIds)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerTaxIds other) {
        return this.euVat.equals(other.euVat);
    }

    public int hashCode() {
        return Objects.hash(this.euVat);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> euVat = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerTaxIds other) {
            this.euVat(other.getEuVat());
            return this;
        }

        @JsonSetter(value="eu_vat", nulls=Nulls.SKIP)
        public Builder euVat(Optional<String> euVat) {
            this.euVat = euVat;
            return this;
        }

        public Builder euVat(String euVat) {
            this.euVat = Optional.ofNullable(euVat);
            return this;
        }

        public Builder euVat(Nullable<String> euVat) {
            this.euVat = euVat.isNull() ? null : (euVat.isEmpty() ? Optional.empty() : Optional.of(euVat.get()));
            return this;
        }

        public CustomerTaxIds build() {
            return new CustomerTaxIds(this.euVat, this.additionalProperties);
        }
    }
}

