/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Customer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerUpdatedEventObject {
    private final Optional<Customer> customer;
    private final Map<String, Object> additionalProperties;

    private CustomerUpdatedEventObject(Optional<Customer> customer, Map<String, Object> additionalProperties) {
        this.customer = customer;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer")
    public Optional<Customer> getCustomer() {
        return this.customer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerUpdatedEventObject && this.equalTo((CustomerUpdatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerUpdatedEventObject other) {
        return this.customer.equals(other.customer);
    }

    public int hashCode() {
        return Objects.hash(this.customer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Customer> customer = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerUpdatedEventObject other) {
            this.customer(other.getCustomer());
            return this;
        }

        @JsonSetter(value="customer", nulls=Nulls.SKIP)
        public Builder customer(Optional<Customer> customer) {
            this.customer = customer;
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = Optional.ofNullable(customer);
            return this;
        }

        public CustomerUpdatedEventObject build() {
            return new CustomerUpdatedEventObject(this.customer, this.additionalProperties);
        }
    }
}

