/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DestinationDetailsCardRefundDetails;
import com.squareup.square.types.DestinationDetailsCashRefundDetails;
import com.squareup.square.types.DestinationDetailsExternalRefundDetails;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DestinationDetails {
    private final Optional<DestinationDetailsCardRefundDetails> cardDetails;
    private final Optional<DestinationDetailsCashRefundDetails> cashDetails;
    private final Optional<DestinationDetailsExternalRefundDetails> externalDetails;
    private final Map<String, Object> additionalProperties;

    private DestinationDetails(Optional<DestinationDetailsCardRefundDetails> cardDetails, Optional<DestinationDetailsCashRefundDetails> cashDetails, Optional<DestinationDetailsExternalRefundDetails> externalDetails, Map<String, Object> additionalProperties) {
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.externalDetails = externalDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="card_details")
    public Optional<DestinationDetailsCardRefundDetails> getCardDetails() {
        return this.cardDetails;
    }

    @JsonProperty(value="cash_details")
    public Optional<DestinationDetailsCashRefundDetails> getCashDetails() {
        return this.cashDetails;
    }

    @JsonProperty(value="external_details")
    public Optional<DestinationDetailsExternalRefundDetails> getExternalDetails() {
        return this.externalDetails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DestinationDetails && this.equalTo((DestinationDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DestinationDetails other) {
        return this.cardDetails.equals(other.cardDetails) && this.cashDetails.equals(other.cashDetails) && this.externalDetails.equals(other.externalDetails);
    }

    public int hashCode() {
        return Objects.hash(this.cardDetails, this.cashDetails, this.externalDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DestinationDetailsCardRefundDetails> cardDetails = Optional.empty();
        private Optional<DestinationDetailsCashRefundDetails> cashDetails = Optional.empty();
        private Optional<DestinationDetailsExternalRefundDetails> externalDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DestinationDetails other) {
            this.cardDetails(other.getCardDetails());
            this.cashDetails(other.getCashDetails());
            this.externalDetails(other.getExternalDetails());
            return this;
        }

        @JsonSetter(value="card_details", nulls=Nulls.SKIP)
        public Builder cardDetails(Optional<DestinationDetailsCardRefundDetails> cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }

        public Builder cardDetails(DestinationDetailsCardRefundDetails cardDetails) {
            this.cardDetails = Optional.ofNullable(cardDetails);
            return this;
        }

        @JsonSetter(value="cash_details", nulls=Nulls.SKIP)
        public Builder cashDetails(Optional<DestinationDetailsCashRefundDetails> cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        public Builder cashDetails(DestinationDetailsCashRefundDetails cashDetails) {
            this.cashDetails = Optional.ofNullable(cashDetails);
            return this;
        }

        @JsonSetter(value="external_details", nulls=Nulls.SKIP)
        public Builder externalDetails(Optional<DestinationDetailsExternalRefundDetails> externalDetails) {
            this.externalDetails = externalDetails;
            return this;
        }

        public Builder externalDetails(DestinationDetailsExternalRefundDetails externalDetails) {
            this.externalDetails = Optional.ofNullable(externalDetails);
            return this;
        }

        public DestinationDetails build() {
            return new DestinationDetails(this.cardDetails, this.cashDetails, this.externalDetails, this.additionalProperties);
        }
    }
}

