/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class DestinationType {
    public static final DestinationType CARD = new DestinationType(Value.CARD, "CARD");
    public static final DestinationType BANK_ACCOUNT = new DestinationType(Value.BANK_ACCOUNT, "BANK_ACCOUNT");
    public static final DestinationType SQUARE_STORED_BALANCE = new DestinationType(Value.SQUARE_STORED_BALANCE, "SQUARE_STORED_BALANCE");
    public static final DestinationType SQUARE_BALANCE = new DestinationType(Value.SQUARE_BALANCE, "SQUARE_BALANCE");
    private final Value value;
    private final String string;

    DestinationType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DestinationType && this.string.equals(((DestinationType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CARD: {
                return visitor.visitCard();
            }
            case BANK_ACCOUNT: {
                return visitor.visitBankAccount();
            }
            case SQUARE_STORED_BALANCE: {
                return visitor.visitSquareStoredBalance();
            }
            case SQUARE_BALANCE: {
                return visitor.visitSquareBalance();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static DestinationType valueOf(String value) {
        switch (value) {
            case "CARD": {
                return CARD;
            }
            case "BANK_ACCOUNT": {
                return BANK_ACCOUNT;
            }
            case "SQUARE_STORED_BALANCE": {
                return SQUARE_STORED_BALANCE;
            }
            case "SQUARE_BALANCE": {
                return SQUARE_BALANCE;
            }
        }
        return new DestinationType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitBankAccount();

        public T visitCard();

        public T visitSquareBalance();

        public T visitSquareStoredBalance();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        BANK_ACCOUNT,
        CARD,
        SQUARE_BALANCE,
        SQUARE_STORED_BALANCE,
        UNKNOWN;

    }
}

