/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceComponentDetailsApplicationDetails {
    private final Optional<String> applicationType;
    private final Optional<String> version;
    private final Optional<String> sessionLocation;
    private final Optional<String> deviceCodeId;
    private final Map<String, Object> additionalProperties;

    private DeviceComponentDetailsApplicationDetails(Optional<String> applicationType, Optional<String> version, Optional<String> sessionLocation, Optional<String> deviceCodeId, Map<String, Object> additionalProperties) {
        this.applicationType = applicationType;
        this.version = version;
        this.sessionLocation = sessionLocation;
        this.deviceCodeId = deviceCodeId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="application_type")
    public Optional<String> getApplicationType() {
        return this.applicationType;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getSessionLocation() {
        if (this.sessionLocation == null) {
            return Optional.empty();
        }
        return this.sessionLocation;
    }

    @JsonIgnore
    public Optional<String> getDeviceCodeId() {
        if (this.deviceCodeId == null) {
            return Optional.empty();
        }
        return this.deviceCodeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="session_location")
    private Optional<String> _getSessionLocation() {
        return this.sessionLocation;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_code_id")
    private Optional<String> _getDeviceCodeId() {
        return this.deviceCodeId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceComponentDetailsApplicationDetails && this.equalTo((DeviceComponentDetailsApplicationDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceComponentDetailsApplicationDetails other) {
        return this.applicationType.equals(other.applicationType) && this.version.equals(other.version) && this.sessionLocation.equals(other.sessionLocation) && this.deviceCodeId.equals(other.deviceCodeId);
    }

    public int hashCode() {
        return Objects.hash(this.applicationType, this.version, this.sessionLocation, this.deviceCodeId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> applicationType = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<String> sessionLocation = Optional.empty();
        private Optional<String> deviceCodeId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceComponentDetailsApplicationDetails other) {
            this.applicationType(other.getApplicationType());
            this.version(other.getVersion());
            this.sessionLocation(other.getSessionLocation());
            this.deviceCodeId(other.getDeviceCodeId());
            return this;
        }

        @JsonSetter(value="application_type", nulls=Nulls.SKIP)
        public Builder applicationType(Optional<String> applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public Builder applicationType(String applicationType) {
            this.applicationType = Optional.ofNullable(applicationType);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public Builder version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="session_location", nulls=Nulls.SKIP)
        public Builder sessionLocation(Optional<String> sessionLocation) {
            this.sessionLocation = sessionLocation;
            return this;
        }

        public Builder sessionLocation(String sessionLocation) {
            this.sessionLocation = Optional.ofNullable(sessionLocation);
            return this;
        }

        public Builder sessionLocation(Nullable<String> sessionLocation) {
            this.sessionLocation = sessionLocation.isNull() ? null : (sessionLocation.isEmpty() ? Optional.empty() : Optional.of(sessionLocation.get()));
            return this;
        }

        @JsonSetter(value="device_code_id", nulls=Nulls.SKIP)
        public Builder deviceCodeId(Optional<String> deviceCodeId) {
            this.deviceCodeId = deviceCodeId;
            return this;
        }

        public Builder deviceCodeId(String deviceCodeId) {
            this.deviceCodeId = Optional.ofNullable(deviceCodeId);
            return this;
        }

        public Builder deviceCodeId(Nullable<String> deviceCodeId) {
            this.deviceCodeId = deviceCodeId.isNull() ? null : (deviceCodeId.isEmpty() ? Optional.empty() : Optional.of(deviceCodeId.get()));
            return this;
        }

        public DeviceComponentDetailsApplicationDetails build() {
            return new DeviceComponentDetailsApplicationDetails(this.applicationType, this.version, this.sessionLocation, this.deviceCodeId, this.additionalProperties);
        }
    }
}

