/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceComponentDetailsExternalPower;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceComponentDetailsBatteryDetails {
    private final Optional<Integer> visiblePercent;
    private final Optional<DeviceComponentDetailsExternalPower> externalPower;
    private final Map<String, Object> additionalProperties;

    private DeviceComponentDetailsBatteryDetails(Optional<Integer> visiblePercent, Optional<DeviceComponentDetailsExternalPower> externalPower, Map<String, Object> additionalProperties) {
        this.visiblePercent = visiblePercent;
        this.externalPower = externalPower;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Integer> getVisiblePercent() {
        if (this.visiblePercent == null) {
            return Optional.empty();
        }
        return this.visiblePercent;
    }

    @JsonProperty(value="external_power")
    public Optional<DeviceComponentDetailsExternalPower> getExternalPower() {
        return this.externalPower;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="visible_percent")
    private Optional<Integer> _getVisiblePercent() {
        return this.visiblePercent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceComponentDetailsBatteryDetails && this.equalTo((DeviceComponentDetailsBatteryDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceComponentDetailsBatteryDetails other) {
        return this.visiblePercent.equals(other.visiblePercent) && this.externalPower.equals(other.externalPower);
    }

    public int hashCode() {
        return Objects.hash(this.visiblePercent, this.externalPower);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> visiblePercent = Optional.empty();
        private Optional<DeviceComponentDetailsExternalPower> externalPower = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceComponentDetailsBatteryDetails other) {
            this.visiblePercent(other.getVisiblePercent());
            this.externalPower(other.getExternalPower());
            return this;
        }

        @JsonSetter(value="visible_percent", nulls=Nulls.SKIP)
        public Builder visiblePercent(Optional<Integer> visiblePercent) {
            this.visiblePercent = visiblePercent;
            return this;
        }

        public Builder visiblePercent(Integer visiblePercent) {
            this.visiblePercent = Optional.ofNullable(visiblePercent);
            return this;
        }

        public Builder visiblePercent(Nullable<Integer> visiblePercent) {
            this.visiblePercent = visiblePercent.isNull() ? null : (visiblePercent.isEmpty() ? Optional.empty() : Optional.of(visiblePercent.get()));
            return this;
        }

        @JsonSetter(value="external_power", nulls=Nulls.SKIP)
        public Builder externalPower(Optional<DeviceComponentDetailsExternalPower> externalPower) {
            this.externalPower = externalPower;
            return this;
        }

        public Builder externalPower(DeviceComponentDetailsExternalPower externalPower) {
            this.externalPower = Optional.ofNullable(externalPower);
            return this;
        }

        public DeviceComponentDetailsBatteryDetails build() {
            return new DeviceComponentDetailsBatteryDetails(this.visiblePercent, this.externalPower, this.additionalProperties);
        }
    }
}

