/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceComponentDetailsEthernetDetails {
    private final Optional<Boolean> active;
    private final Optional<String> ipAddressV4;
    private final Map<String, Object> additionalProperties;

    private DeviceComponentDetailsEthernetDetails(Optional<Boolean> active, Optional<String> ipAddressV4, Map<String, Object> additionalProperties) {
        this.active = active;
        this.ipAddressV4 = ipAddressV4;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getActive() {
        if (this.active == null) {
            return Optional.empty();
        }
        return this.active;
    }

    @JsonIgnore
    public Optional<String> getIpAddressV4() {
        if (this.ipAddressV4 == null) {
            return Optional.empty();
        }
        return this.ipAddressV4;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="active")
    private Optional<Boolean> _getActive() {
        return this.active;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ip_address_v4")
    private Optional<String> _getIpAddressV4() {
        return this.ipAddressV4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceComponentDetailsEthernetDetails && this.equalTo((DeviceComponentDetailsEthernetDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceComponentDetailsEthernetDetails other) {
        return this.active.equals(other.active) && this.ipAddressV4.equals(other.ipAddressV4);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.ipAddressV4);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> active = Optional.empty();
        private Optional<String> ipAddressV4 = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceComponentDetailsEthernetDetails other) {
            this.active(other.getActive());
            this.ipAddressV4(other.getIpAddressV4());
            return this;
        }

        @JsonSetter(value="active", nulls=Nulls.SKIP)
        public Builder active(Optional<Boolean> active) {
            this.active = active;
            return this;
        }

        public Builder active(Boolean active) {
            this.active = Optional.ofNullable(active);
            return this;
        }

        public Builder active(Nullable<Boolean> active) {
            this.active = active.isNull() ? null : (active.isEmpty() ? Optional.empty() : Optional.of(active.get()));
            return this;
        }

        @JsonSetter(value="ip_address_v4", nulls=Nulls.SKIP)
        public Builder ipAddressV4(Optional<String> ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = Optional.ofNullable(ipAddressV4);
            return this;
        }

        public Builder ipAddressV4(Nullable<String> ipAddressV4) {
            this.ipAddressV4 = ipAddressV4.isNull() ? null : (ipAddressV4.isEmpty() ? Optional.empty() : Optional.of(ipAddressV4.get()));
            return this;
        }

        public DeviceComponentDetailsEthernetDetails build() {
            return new DeviceComponentDetailsEthernetDetails(this.active, this.ipAddressV4, this.additionalProperties);
        }
    }
}

