/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceComponentDetailsMeasurement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceComponentDetailsWiFiDetails {
    private final Optional<Boolean> active;
    private final Optional<String> ssid;
    private final Optional<String> ipAddressV4;
    private final Optional<String> secureConnection;
    private final Optional<DeviceComponentDetailsMeasurement> signalStrength;
    private final Map<String, Object> additionalProperties;

    private DeviceComponentDetailsWiFiDetails(Optional<Boolean> active, Optional<String> ssid, Optional<String> ipAddressV4, Optional<String> secureConnection, Optional<DeviceComponentDetailsMeasurement> signalStrength, Map<String, Object> additionalProperties) {
        this.active = active;
        this.ssid = ssid;
        this.ipAddressV4 = ipAddressV4;
        this.secureConnection = secureConnection;
        this.signalStrength = signalStrength;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getActive() {
        if (this.active == null) {
            return Optional.empty();
        }
        return this.active;
    }

    @JsonIgnore
    public Optional<String> getSsid() {
        if (this.ssid == null) {
            return Optional.empty();
        }
        return this.ssid;
    }

    @JsonIgnore
    public Optional<String> getIpAddressV4() {
        if (this.ipAddressV4 == null) {
            return Optional.empty();
        }
        return this.ipAddressV4;
    }

    @JsonIgnore
    public Optional<String> getSecureConnection() {
        if (this.secureConnection == null) {
            return Optional.empty();
        }
        return this.secureConnection;
    }

    @JsonProperty(value="signal_strength")
    public Optional<DeviceComponentDetailsMeasurement> getSignalStrength() {
        return this.signalStrength;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="active")
    private Optional<Boolean> _getActive() {
        return this.active;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ssid")
    private Optional<String> _getSsid() {
        return this.ssid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ip_address_v4")
    private Optional<String> _getIpAddressV4() {
        return this.ipAddressV4;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="secure_connection")
    private Optional<String> _getSecureConnection() {
        return this.secureConnection;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceComponentDetailsWiFiDetails && this.equalTo((DeviceComponentDetailsWiFiDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceComponentDetailsWiFiDetails other) {
        return this.active.equals(other.active) && this.ssid.equals(other.ssid) && this.ipAddressV4.equals(other.ipAddressV4) && this.secureConnection.equals(other.secureConnection) && this.signalStrength.equals(other.signalStrength);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.ssid, this.ipAddressV4, this.secureConnection, this.signalStrength);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> active = Optional.empty();
        private Optional<String> ssid = Optional.empty();
        private Optional<String> ipAddressV4 = Optional.empty();
        private Optional<String> secureConnection = Optional.empty();
        private Optional<DeviceComponentDetailsMeasurement> signalStrength = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceComponentDetailsWiFiDetails other) {
            this.active(other.getActive());
            this.ssid(other.getSsid());
            this.ipAddressV4(other.getIpAddressV4());
            this.secureConnection(other.getSecureConnection());
            this.signalStrength(other.getSignalStrength());
            return this;
        }

        @JsonSetter(value="active", nulls=Nulls.SKIP)
        public Builder active(Optional<Boolean> active) {
            this.active = active;
            return this;
        }

        public Builder active(Boolean active) {
            this.active = Optional.ofNullable(active);
            return this;
        }

        public Builder active(Nullable<Boolean> active) {
            this.active = active.isNull() ? null : (active.isEmpty() ? Optional.empty() : Optional.of(active.get()));
            return this;
        }

        @JsonSetter(value="ssid", nulls=Nulls.SKIP)
        public Builder ssid(Optional<String> ssid) {
            this.ssid = ssid;
            return this;
        }

        public Builder ssid(String ssid) {
            this.ssid = Optional.ofNullable(ssid);
            return this;
        }

        public Builder ssid(Nullable<String> ssid) {
            this.ssid = ssid.isNull() ? null : (ssid.isEmpty() ? Optional.empty() : Optional.of(ssid.get()));
            return this;
        }

        @JsonSetter(value="ip_address_v4", nulls=Nulls.SKIP)
        public Builder ipAddressV4(Optional<String> ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = Optional.ofNullable(ipAddressV4);
            return this;
        }

        public Builder ipAddressV4(Nullable<String> ipAddressV4) {
            this.ipAddressV4 = ipAddressV4.isNull() ? null : (ipAddressV4.isEmpty() ? Optional.empty() : Optional.of(ipAddressV4.get()));
            return this;
        }

        @JsonSetter(value="secure_connection", nulls=Nulls.SKIP)
        public Builder secureConnection(Optional<String> secureConnection) {
            this.secureConnection = secureConnection;
            return this;
        }

        public Builder secureConnection(String secureConnection) {
            this.secureConnection = Optional.ofNullable(secureConnection);
            return this;
        }

        public Builder secureConnection(Nullable<String> secureConnection) {
            this.secureConnection = secureConnection.isNull() ? null : (secureConnection.isEmpty() ? Optional.empty() : Optional.of(secureConnection.get()));
            return this;
        }

        @JsonSetter(value="signal_strength", nulls=Nulls.SKIP)
        public Builder signalStrength(Optional<DeviceComponentDetailsMeasurement> signalStrength) {
            this.signalStrength = signalStrength;
            return this;
        }

        public Builder signalStrength(DeviceComponentDetailsMeasurement signalStrength) {
            this.signalStrength = Optional.ofNullable(signalStrength);
            return this;
        }

        public DeviceComponentDetailsWiFiDetails build() {
            return new DeviceComponentDetailsWiFiDetails(this.active, this.ssid, this.ipAddressV4, this.secureConnection, this.signalStrength, this.additionalProperties);
        }
    }
}

