/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Device;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceCreatedEventObject {
    private final Optional<Device> device;
    private final Map<String, Object> additionalProperties;

    private DeviceCreatedEventObject(Optional<Device> device, Map<String, Object> additionalProperties) {
        this.device = device;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="device")
    public Optional<Device> getDevice() {
        return this.device;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceCreatedEventObject && this.equalTo((DeviceCreatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceCreatedEventObject other) {
        return this.device.equals(other.device);
    }

    public int hashCode() {
        return Objects.hash(this.device);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Device> device = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceCreatedEventObject other) {
            this.device(other.getDevice());
            return this;
        }

        @JsonSetter(value="device", nulls=Nulls.SKIP)
        public Builder device(Optional<Device> device) {
            this.device = device;
            return this;
        }

        public Builder device(Device device) {
            this.device = Optional.ofNullable(device);
            return this;
        }

        public DeviceCreatedEventObject build() {
            return new DeviceCreatedEventObject(this.device, this.additionalProperties);
        }
    }
}

