/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CashAppDetails;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DigitalWalletDetails {
    private final Optional<String> status;
    private final Optional<String> brand;
    private final Optional<CashAppDetails> cashAppDetails;
    private final Map<String, Object> additionalProperties;

    private DigitalWalletDetails(Optional<String> status, Optional<String> brand, Optional<CashAppDetails> cashAppDetails, Map<String, Object> additionalProperties) {
        this.status = status;
        this.brand = brand;
        this.cashAppDetails = cashAppDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getBrand() {
        if (this.brand == null) {
            return Optional.empty();
        }
        return this.brand;
    }

    @JsonProperty(value="cash_app_details")
    public Optional<CashAppDetails> getCashAppDetails() {
        return this.cashAppDetails;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<String> _getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="brand")
    private Optional<String> _getBrand() {
        return this.brand;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DigitalWalletDetails && this.equalTo((DigitalWalletDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DigitalWalletDetails other) {
        return this.status.equals(other.status) && this.brand.equals(other.brand) && this.cashAppDetails.equals(other.cashAppDetails);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.brand, this.cashAppDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> status = Optional.empty();
        private Optional<String> brand = Optional.empty();
        private Optional<CashAppDetails> cashAppDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DigitalWalletDetails other) {
            this.status(other.getStatus());
            this.brand(other.getBrand());
            this.cashAppDetails(other.getCashAppDetails());
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Nullable<String> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        @JsonSetter(value="brand", nulls=Nulls.SKIP)
        public Builder brand(Optional<String> brand) {
            this.brand = brand;
            return this;
        }

        public Builder brand(String brand) {
            this.brand = Optional.ofNullable(brand);
            return this;
        }

        public Builder brand(Nullable<String> brand) {
            this.brand = brand.isNull() ? null : (brand.isEmpty() ? Optional.empty() : Optional.of(brand.get()));
            return this;
        }

        @JsonSetter(value="cash_app_details", nulls=Nulls.SKIP)
        public Builder cashAppDetails(Optional<CashAppDetails> cashAppDetails) {
            this.cashAppDetails = cashAppDetails;
            return this;
        }

        public Builder cashAppDetails(CashAppDetails cashAppDetails) {
            this.cashAppDetails = Optional.ofNullable(cashAppDetails);
            return this;
        }

        public DigitalWalletDetails build() {
            return new DigitalWalletDetails(this.status, this.brand, this.cashAppDetails, this.additionalProperties);
        }
    }
}

