/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.TerminalCheckout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DismissTerminalCheckoutResponse {
    private final Optional<List<Error>> errors;
    private final Optional<TerminalCheckout> checkout;
    private final Map<String, Object> additionalProperties;

    private DismissTerminalCheckoutResponse(Optional<List<Error>> errors, Optional<TerminalCheckout> checkout, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.checkout = checkout;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="checkout")
    public Optional<TerminalCheckout> getCheckout() {
        return this.checkout;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DismissTerminalCheckoutResponse && this.equalTo((DismissTerminalCheckoutResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DismissTerminalCheckoutResponse other) {
        return this.errors.equals(other.errors) && this.checkout.equals(other.checkout);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.checkout);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<TerminalCheckout> checkout = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DismissTerminalCheckoutResponse other) {
            this.errors(other.getErrors());
            this.checkout(other.getCheckout());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="checkout", nulls=Nulls.SKIP)
        public Builder checkout(Optional<TerminalCheckout> checkout) {
            this.checkout = checkout;
            return this;
        }

        public Builder checkout(TerminalCheckout checkout) {
            this.checkout = Optional.ofNullable(checkout);
            return this;
        }

        public DismissTerminalCheckoutResponse build() {
            return new DismissTerminalCheckoutResponse(this.errors, this.checkout, this.additionalProperties);
        }
    }
}

